/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Instant;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RetryTimeoutException;
import org.projectnessie.versioned.storage.common.indexes.ElementSerializer;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexes;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.objtypes.UniqueIdObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.ObjTypes;
import org.projectnessie.versioned.storage.serialize.SmileSerialization;
import org.projectnessie.versioned.transfer.ImportPersistCommon;
import org.projectnessie.versioned.transfer.NessieImporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

final class ImportPersistV23
extends ImportPersistCommon {
    ImportPersistV23(TransferTypes.ExportMeta exportMeta, NessieImporter importer) {
        super(exportMeta, importer);
    }

    @Override
    void prepareRepository() throws IOException {
        TransferTypes.RepositoryDescriptionProto repositoryDescription = this.importer.loadRepositoryDescription();
        this.importer.repositoryLogic().initialize(repositoryDescription.getDefaultBranchName(), false, b -> {
            if (repositoryDescription.hasOldestCommitTimestampMillis()) {
                b.oldestPossibleCommitTime(Instant.ofEpochMilli(repositoryDescription.getOldestCommitTimestampMillis()));
            }
            b.putAllProperties(repositoryDescription.getPropertiesMap());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long importNamedReferences() throws IOException {
        try {
            long namedReferenceCount = 0L;
            for (String fileName : this.exportMeta.getNamedReferencesFilesList()) {
                InputStream input = this.importFiles.newFileInput(fileName);
                try {
                    TransferTypes.Ref ref;
                    while ((ref = TransferTypes.Ref.parseDelimitedFrom((InputStream)input)) != null) {
                        try {
                            ByteString ext = ref.getExtendedInfoObj();
                            if (ref.hasCreatedAtMicros()) {
                                this.importer.referenceLogic().createReferenceForImport(ref.getName(), ObjId.objIdFromBytes((ByteString)ref.getPointer()), ext == null ? null : ObjId.objIdFromBytes((ByteString)ext), ref.getCreatedAtMicros());
                            } else {
                                this.importer.referenceLogic().createReference(ref.getName(), ObjId.objIdFromBytes((ByteString)ref.getPointer()), ext == null ? null : ObjId.objIdFromBytes((ByteString)ext));
                            }
                        }
                        catch (RefAlreadyExistsException | RetryTimeoutException e) {
                            throw new RuntimeException(e);
                        }
                        ++namedReferenceCount;
                        this.importer.progressListener().progress(ProgressEvent.NAMED_REFERENCE_WRITTEN);
                    }
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            long l = namedReferenceCount;
            return l;
        }
        finally {
            this.persist.flush();
        }
    }

    @Override
    void processCommit(TransferTypes.Commit commit) throws ObjTooLargeException {
        CommitHeaders.Builder headers = CommitHeaders.newCommitHeaders();
        commit.getHeadersList().forEach(h -> h.getValuesList().forEach(v -> headers.add(h.getName(), v)));
        CommitObj.Builder c = CommitObj.commitBuilder().id(ObjId.objIdFromBytes((ByteString)commit.getCommitId())).addTail(ObjId.objIdFromBytes((ByteString)commit.getParentCommitId())).created(commit.getCreatedTimeMicros()).seq(commit.getCommitSequence()).message(commit.getMessage()).headers(headers.build()).incompleteIndex(true);
        commit.getAdditionalParentsList().forEach(ap -> c.addSecondaryParents(ObjId.objIdFromBytes((ByteString)ap)));
        StoreIndex index = StoreIndexes.newStoreIndex((ElementSerializer)CommitOp.COMMIT_OP_SERIALIZER);
        commit.getOperationsList().forEach(op -> {
            StoreKey storeKey = StoreKey.keyFromString((String)op.getContentKey(0));
            this.processCommitOp((StoreIndex<CommitOp>)index, (TransferTypes.Operation)op, storeKey);
        });
        c.incrementalIndex(index.serialize());
        this.persist.storeObj((Obj)c.build());
        this.importer.progressListener().progress(ProgressEvent.COMMIT_WRITTEN);
    }

    @Override
    void processGeneric(TransferTypes.RelatedObj genericObj) throws ObjTooLargeException {
        UniqueIdObj obj;
        ObjType type = ObjTypes.objTypeByName((String)genericObj.getTypeName());
        ObjId id = ObjId.objIdFromBytes((ByteString)genericObj.getId());
        if (type.equals((Object)StandardObjType.UNIQUE)) {
            obj = UniqueIdObj.uniqueId((ObjId)id, (long)0L, (String)genericObj.getSpace(), (ByteString)genericObj.getData());
        } else {
            String versionToken;
            ByteBuffer data = genericObj.getData().asReadOnlyByteBuffer();
            String string = versionToken = genericObj.hasVersionToken() ? genericObj.getVersionToken() : null;
            if (genericObj.getEncodingValue() != 1) {
                throw new IllegalArgumentException("Unsupported generic object encoding " + String.valueOf(genericObj.getEncoding()));
            }
            obj = SmileSerialization.deserializeObj((ObjId)id, (String)versionToken, (ByteBuffer)data, (ObjType)type, (long)0L, (Compression)Compression.fromValue((String)genericObj.getCompression()));
        }
        this.persist.storeObj((Obj)obj);
        this.importer.progressListener().progress(ProgressEvent.GENERIC_WRITTEN);
    }
}

