/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URL;
import java.time.Clock;
import java.util.List;
import org.immutables.value.Value;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.storage.common.logic.CommitLogic;
import org.projectnessie.versioned.storage.common.logic.IndexesLogic;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.ReferenceLogic;
import org.projectnessie.versioned.storage.common.logic.RepositoryLogic;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.transfer.ExportContents;
import org.projectnessie.versioned.transfer.ExportPersist;
import org.projectnessie.versioned.transfer.ImmutableNessieExporter;
import org.projectnessie.versioned.transfer.ProgressListener;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

@Value.Immutable
public abstract class NessieExporter {
    public static final String NAMED_REFS_PREFIX = "named-refs";
    public static final String COMMITS_PREFIX = "commits";
    public static final String CUSTOM_PREFIX = "custom";

    public static Builder builder() {
        return ImmutableNessieExporter.builder();
    }

    abstract Persist persist();

    @Value.Default
    CommitLogic commitLogic() {
        return Logics.commitLogic((Persist)this.persist());
    }

    @Value.Default
    ReferenceLogic referenceLogic() {
        return Logics.referenceLogic((Persist)this.persist());
    }

    @Value.Default
    RepositoryLogic repositoryLogic() {
        return Logics.repositoryLogic((Persist)this.persist());
    }

    @Value.Default
    IndexesLogic indexesLogic() {
        return Logics.indexesLogic((Persist)this.persist());
    }

    @Nullable
    abstract VersionStore versionStore();

    @Value.Lazy
    Clock clock() {
        Persist persist = this.persist();
        return persist.config().clock();
    }

    @Value.Default
    boolean fullScan() {
        return false;
    }

    @Nullable
    @Value.Default
    String contentsFromBranch() {
        return null;
    }

    @Value.Default
    int contentsBatchSize() {
        return 100;
    }

    @Value.Default
    ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Value.Default
    StoreWorker storeWorker() {
        return DefaultStoreWorker.instance();
    }

    @Value.Default
    int outputBufferSize() {
        return 32768;
    }

    @Value.Default
    long maxFileSize() {
        return Long.MAX_VALUE;
    }

    @Value.Default
    int expectedCommitCount() {
        return 1000000;
    }

    @Value.Default
    int commitBatchSize() {
        return 20;
    }

    @Value.Default
    int exportVersion() {
        return 3;
    }

    abstract List<URL> genericObjectResolvers();

    abstract ExportFileSupplier exportFileSupplier();

    @Value.Default
    ProgressListener progressListener() {
        return (x, y) -> {};
    }

    public TransferTypes.ExportMeta exportNessieRepository() throws IOException {
        ExportFileSupplier exportFiles = this.exportFileSupplier();
        exportFiles.preValidate();
        TransferTypes.ExportVersion ver = TransferTypes.ExportVersion.forNumber((int)this.exportVersion());
        if (this.contentsFromBranch() != null) {
            return new ExportContents(exportFiles, this, ver).exportRepo();
        }
        return new ExportPersist(exportFiles, this, ver).exportRepo();
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder persist(Persist var1);

        @CanIgnoreReturnValue
        public Builder commitLogic(CommitLogic var1);

        @CanIgnoreReturnValue
        public Builder referenceLogic(ReferenceLogic var1);

        @CanIgnoreReturnValue
        public Builder repositoryLogic(RepositoryLogic var1);

        @CanIgnoreReturnValue
        public Builder indexesLogic(IndexesLogic var1);

        @CanIgnoreReturnValue
        public Builder versionStore(VersionStore var1);

        @CanIgnoreReturnValue
        public Builder objectMapper(ObjectMapper var1);

        @CanIgnoreReturnValue
        public Builder storeWorker(StoreWorker var1);

        @CanIgnoreReturnValue
        public Builder outputBufferSize(int var1);

        @CanIgnoreReturnValue
        public Builder maxFileSize(long var1);

        @CanIgnoreReturnValue
        public Builder expectedCommitCount(int var1);

        @CanIgnoreReturnValue
        public Builder progressListener(ProgressListener var1);

        @CanIgnoreReturnValue
        public Builder exportFileSupplier(ExportFileSupplier var1);

        @CanIgnoreReturnValue
        public Builder fullScan(boolean var1);

        @CanIgnoreReturnValue
        public Builder contentsFromBranch(String var1);

        @CanIgnoreReturnValue
        public Builder contentsBatchSize(int var1);

        @CanIgnoreReturnValue
        public Builder commitBatchSize(int var1);

        @CanIgnoreReturnValue
        public Builder exportVersion(int var1);

        @CanIgnoreReturnValue
        public Builder addGenericObjectResolvers(URL var1);

        public NessieExporter build();
    }
}

