/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer.files;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.immutables.value.Value;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.files.ImmutableZipArchiveExporter;

@Value.Immutable
public abstract class ZipArchiveExporter
implements ExportFileSupplier {
    private final Set<DelayedOutputStream> activeOutputStreams = new HashSet<DelayedOutputStream>();

    public static Builder builder() {
        return ImmutableZipArchiveExporter.builder();
    }

    abstract Path outputFile();

    @Value.Lazy
    Path tempOutputFile() {
        Path out = this.outputFile();
        return out.resolveSibling("." + out.getFileName().toString() + ".tmp");
    }

    @Value.Lazy
    ZipOutputStream zipOutput() throws IOException {
        Path parent = this.outputFile().getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        return new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(this.tempOutputFile(), new OpenOption[0])));
    }

    @Override
    public long fixMaxFileSize(long userProvidedMaxFileSize) {
        return Math.max(65536L, Math.min(0xA00000L, userProvidedMaxFileSize));
    }

    @Override
    public void preValidate() {
    }

    @Override
    @Nonnull
    public Path getTargetPath() {
        return this.outputFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public OutputStream newFileOutput(@Nonnull String fileName) throws IOException {
        Preconditions.checkArgument((fileName.indexOf(47) == -1 && fileName.indexOf(92) == -1 ? 1 : 0) != 0, (Object)"Directories not supported");
        Preconditions.checkArgument((!fileName.isEmpty() ? 1 : 0) != 0, (Object)"Invalid file name argument");
        DelayedOutputStream output = new DelayedOutputStream(fileName);
        Set<DelayedOutputStream> set = this.activeOutputStreams;
        synchronized (set) {
            this.activeOutputStreams.add(output);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        try {
            ArrayList<DelayedOutputStream> activeOutputs;
            Set<DelayedOutputStream> set = this.activeOutputStreams;
            synchronized (set) {
                activeOutputs = new ArrayList<DelayedOutputStream>(this.activeOutputStreams);
            }
            for (DelayedOutputStream active : activeOutputs) {
                active.close();
            }
            this.zipOutput().close();
        }
        finally {
            Files.deleteIfExists(this.outputFile());
            if (Files.isRegularFile(this.tempOutputFile(), new LinkOption[0])) {
                Files.move(this.tempOutputFile(), this.outputFile(), new CopyOption[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayedFinished(DelayedOutputStream delayedOutputStream) {
        Set<DelayedOutputStream> set = this.activeOutputStreams;
        synchronized (set) {
            this.activeOutputStreams.remove(delayedOutputStream);
        }
    }

    private final class DelayedOutputStream
    extends OutputStream {
        private boolean open = true;
        private final String name;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        private DelayedOutputStream(String name) {
            this.name = name;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            Preconditions.checkState((boolean)this.open);
            this.buffer.write(b, off, len);
        }

        @Override
        public void write(int b) {
            Preconditions.checkState((boolean)this.open);
            this.buffer.write(b);
        }

        @Override
        public void flush() throws IOException {
            Preconditions.checkState((boolean)this.open);
            this.buffer.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.open) {
                try {
                    ZipOutputStream out = ZipArchiveExporter.this.zipOutput();
                    out.putNextEntry(new ZipEntry(this.name));
                    this.buffer.writeTo(out);
                    out.closeEntry();
                }
                finally {
                    ZipArchiveExporter.this.delayedFinished(this);
                    this.open = false;
                }
            }
        }
    }

    public static interface Builder {
        public Builder outputFile(Path var1);

        public ZipArchiveExporter build();
    }
}

