/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.CommitLogQuery;
import org.projectnessie.versioned.storage.common.logic.HeadsAndForkPoints;
import org.projectnessie.versioned.storage.common.logic.IdentifyHeadsAndForkPoints;
import org.projectnessie.versioned.storage.common.logic.PagedResult;
import org.projectnessie.versioned.storage.common.logic.ReferencesQuery;
import org.projectnessie.versioned.storage.common.logic.RepositoryDescription;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.ContentValueObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.versionstore.RefMapping;
import org.projectnessie.versioned.storage.versionstore.TypeMapping;
import org.projectnessie.versioned.transfer.Batcher;
import org.projectnessie.versioned.transfer.ExportCommon;
import org.projectnessie.versioned.transfer.ExportContext;
import org.projectnessie.versioned.transfer.NessieExporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

final class ExportPersist
extends ExportCommon {
    private final TransferTypes.ExportVersion exportVersion;

    ExportPersist(ExportFileSupplier exportFiles, NessieExporter exporter, TransferTypes.ExportVersion exportVersion) {
        super(exportFiles, exporter);
        this.exportVersion = exportVersion;
    }

    @Override
    TransferTypes.ExportVersion getExportVersion() {
        return this.exportVersion;
    }

    @Override
    TransferTypes.HeadsAndForks exportCommits(ExportContext exportContext) {
        HeadsAndForkPoints headsAndForkPoints;
        try (Batcher commitObjBatcher = new Batcher(this.exporter.commitBatchSize(), commits -> this.mapCommitObjs((List<CommitObj>)commits, exportContext));){
            headsAndForkPoints = this.exporter.fullScan() ? this.scanDatabase(commitObjBatcher::add) : this.scanAllReferences(commitObjBatcher::add);
        }
        TransferTypes.HeadsAndForks.Builder hf = TransferTypes.HeadsAndForks.newBuilder().setScanStartedAtInMicros(headsAndForkPoints.getScanStartedAtInMicros());
        headsAndForkPoints.getHeads().forEach(h -> hf.addHeads(h.asBytes()));
        headsAndForkPoints.getForkPoints().forEach(h -> hf.addForkPoints(h.asBytes()));
        return hf.build();
    }

    private HeadsAndForkPoints scanAllReferences(Consumer<CommitObj> commitHandler) {
        IdentifyHeadsAndForkPoints identify = new IdentifyHeadsAndForkPoints(this.exporter.expectedCommitCount(), this.exporter.persist().config().currentTimeMicros());
        String referencePrefix = this.exportVersion == TransferTypes.ExportVersion.V2 ? null : "refs/";
        this.exporter.referenceLogic().queryReferences(ReferencesQuery.referencesQuery((String)referencePrefix)).forEachRemaining(ref -> {
            ArrayDeque<ObjId> commitsToProcess = new ArrayDeque<ObjId>();
            commitsToProcess.offerFirst(ref.pointer());
            while (!commitsToProcess.isEmpty()) {
                CommitObj commit;
                ObjId id = (ObjId)commitsToProcess.removeFirst();
                if (!identify.isCommitNew(id)) continue;
                PagedResult commitIter = this.exporter.commitLogic().commitLog(CommitLogQuery.commitLogQuery((ObjId)id));
                while (commitIter.hasNext() && identify.handleCommit(commit = (CommitObj)commitIter.next())) {
                    commitHandler.accept(commit);
                    for (ObjId parentId : commit.secondaryParents()) {
                        if (!identify.isCommitNew(parentId)) continue;
                        commitsToProcess.addLast(parentId);
                    }
                }
            }
        });
        return identify.finish();
    }

    private HeadsAndForkPoints scanDatabase(Consumer<CommitObj> commitHandler) {
        return this.exporter.commitLogic().identifyAllHeadsAndForkPoints(this.exporter.expectedCommitCount(), commitHandler);
    }

    @Override
    void exportReferences(ExportContext exportContext) {
        String referencePrefix = this.exportVersion == TransferTypes.ExportVersion.V2 ? null : "refs/";
        PagedResult refs = this.exporter.referenceLogic().queryReferences(ReferencesQuery.referencesQuery((String)referencePrefix));
        while (refs.hasNext()) {
            Reference reference = (Reference)refs.next();
            if (this.exportVersion == TransferTypes.ExportVersion.V1) {
                NamedRef namedRef = RefMapping.referenceToNamedRef((Reference)reference);
                TransferTypes.NamedReference.Builder namedReference = TransferTypes.NamedReference.newBuilder().setRefType(this.refType(namedRef)).setName(namedRef.getName()).setCommitId(reference.pointer().asBytes());
                exportContext.writeNamedReference(namedReference.build());
            } else {
                ObjId extendedInfoObj = reference.extendedInfoObj();
                TransferTypes.Ref.Builder refBuilder = TransferTypes.Ref.newBuilder().setName(reference.name()).setPointer(reference.pointer().asBytes());
                if (extendedInfoObj != null) {
                    refBuilder.setExtendedInfoObj(extendedInfoObj.asBytes());
                }
                exportContext.writeRef(refBuilder.build());
            }
            this.exporter.progressListener().progress(ProgressEvent.NAMED_REFERENCE_WRITTEN);
        }
    }

    private TransferTypes.RefType refType(NamedRef namedRef) {
        if (namedRef instanceof TagName) {
            return TransferTypes.RefType.Tag;
        }
        if (namedRef instanceof BranchName) {
            return TransferTypes.RefType.Branch;
        }
        throw new IllegalArgumentException("Unknown named reference type " + namedRef);
    }

    @Override
    void writeRepositoryDescription() throws IOException {
        RepositoryDescription repositoryDescription = this.exporter.repositoryLogic().fetchRepositoryDescription();
        if (repositoryDescription != null) {
            this.writeRepositoryDescription(TransferTypes.RepositoryDescriptionProto.newBuilder().putAllProperties(repositoryDescription.properties()).setRepositoryId(this.exporter.persist().config().repositoryId()).setRepositoryCreatedTimestampMillis(repositoryDescription.repositoryCreatedTime().toEpochMilli()).setOldestCommitTimestampMillis(repositoryDescription.oldestPossibleCommitTime().toEpochMilli()).setDefaultBranchName(repositoryDescription.defaultBranchName()).build());
        }
    }

    private void mapCommitObjs(List<CommitObj> commitObjs, ExportContext exportContext) {
        Map<ObjId, Obj> objs = this.fetchReferencedObjs(commitObjs);
        for (CommitObj c : commitObjs) {
            TransferTypes.Commit commit = this.mapCommitObj(c, objs);
            exportContext.writeCommit(commit);
            this.exporter.progressListener().progress(ProgressEvent.COMMIT_WRITTEN);
        }
    }

    private Map<ObjId, Obj> fetchReferencedObjs(List<CommitObj> commitObjs) {
        try {
            ObjId[] valueIds = (ObjId[])commitObjs.stream().flatMap(c -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.exporter.indexesLogic().commitOperations(c).iterator(), 0), false).map(op -> ((CommitOp)op.content()).value()).filter(Objects::nonNull)).distinct().toArray(ObjId[]::new);
            return valueIds.length > 0 ? Arrays.stream(this.exporter.persist().fetchObjs(valueIds)).filter(Objects::nonNull).collect(Collectors.toMap(Obj::id, Function.identity())) : Collections.emptyMap();
        }
        catch (ObjNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private TransferTypes.Commit mapCommitObj(CommitObj c, Map<ObjId, Obj> objs) {
        TransferTypes.Commit.Builder b = TransferTypes.Commit.newBuilder().setCommitId(c.id().asBytes()).setParentCommitId(((ObjId)c.tail().get(0)).asBytes()).setMessage(c.message()).setCommitSequence(c.seq()).setCreatedTimeMicros(c.created());
        if (this.exportVersion == TransferTypes.ExportVersion.V1) {
            try {
                CommitMeta commitMeta = TypeMapping.toCommitMeta((CommitObj)c);
                byte[] commitMetaBytes = this.exporter.objectMapper().writeValueAsBytes((Object)commitMeta);
                b.setMetadata(ByteString.copyFrom((byte[])commitMetaBytes));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        c.headers().keySet().forEach(h -> b.addHeadersBuilder().setName(h).addAllValues((Iterable)c.headers().getAll(h)));
        c.secondaryParents().forEach(p -> b.addAdditionalParents(p.asBytes()));
        this.exporter.indexesLogic().commitOperations(c).forEach(op -> {
            CommitOp content = (CommitOp)op.content();
            TransferTypes.Operation.Builder opBuilder = b.addOperationsBuilder().setPayload(content.payload());
            if (this.exportVersion == TransferTypes.ExportVersion.V1) {
                opBuilder.addAllContentKey((Iterable)TypeMapping.storeKeyToKey((StoreKey)op.key()).getElements());
            } else {
                opBuilder.addContentKey(op.key().rawString());
            }
            ObjId valueId = content.value();
            if (valueId != null) {
                try {
                    ContentValueObj value = (ContentValueObj)objs.get(valueId);
                    Content modelContent = this.exporter.storeWorker().valueFromStore((int)((byte)content.payload()), value.data());
                    byte[] modelContentBytes = this.exporter.objectMapper().writeValueAsBytes((Object)modelContent);
                    opBuilder.setContentId(value.contentId()).setValue(ByteString.copyFrom((byte[])modelContentBytes));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            if (content.action().exists()) {
                opBuilder.setOperationType(TransferTypes.OperationType.Put);
            } else {
                opBuilder.setOperationType(TransferTypes.OperationType.Delete);
            }
        });
        return b.build();
    }
}

