/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.storage.common.logic.CommitLogic;
import org.projectnessie.versioned.storage.common.logic.IndexesLogic;
import org.projectnessie.versioned.storage.common.logic.ReferenceLogic;
import org.projectnessie.versioned.storage.common.logic.RepositoryLogic;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.transfer.NessieExporter;
import org.projectnessie.versioned.transfer.ProgressListener;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NessieExporter", generator="Immutables")
@Immutable
public final class ImmutableNessieExporter
extends NessieExporter {
    private final Persist persist;
    private final CommitLogic commitLogic;
    private final ReferenceLogic referenceLogic;
    private final RepositoryLogic repositoryLogic;
    private final IndexesLogic indexesLogic;
    @Nullable
    private final VersionStore versionStore;
    private final boolean fullScan;
    @Nullable
    private final String contentsFromBranch;
    private final int contentsBatchSize;
    private final ObjectMapper objectMapper;
    private final StoreWorker storeWorker;
    private final int outputBufferSize;
    private final long maxFileSize;
    private final int expectedCommitCount;
    private final int commitBatchSize;
    private final int exportVersion;
    private final ExportFileSupplier exportFileSupplier;
    private final ProgressListener progressListener;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long CLOCK_LAZY_INIT_BIT = 1L;
    private transient Clock clock;

    private ImmutableNessieExporter(Builder builder) {
        this.persist = builder.persist;
        this.versionStore = builder.versionStore;
        this.exportFileSupplier = builder.exportFileSupplier;
        if (builder.commitLogic != null) {
            this.initShim.commitLogic(builder.commitLogic);
        }
        if (builder.referenceLogic != null) {
            this.initShim.referenceLogic(builder.referenceLogic);
        }
        if (builder.repositoryLogic != null) {
            this.initShim.repositoryLogic(builder.repositoryLogic);
        }
        if (builder.indexesLogic != null) {
            this.initShim.indexesLogic(builder.indexesLogic);
        }
        if (builder.fullScanIsSet()) {
            this.initShim.fullScan(builder.fullScan);
        }
        if (builder.contentsFromBranchIsSet()) {
            this.initShim.contentsFromBranch(builder.contentsFromBranch);
        }
        if (builder.contentsBatchSizeIsSet()) {
            this.initShim.contentsBatchSize(builder.contentsBatchSize);
        }
        if (builder.objectMapper != null) {
            this.initShim.objectMapper(builder.objectMapper);
        }
        if (builder.storeWorker != null) {
            this.initShim.storeWorker(builder.storeWorker);
        }
        if (builder.outputBufferSizeIsSet()) {
            this.initShim.outputBufferSize(builder.outputBufferSize);
        }
        if (builder.maxFileSizeIsSet()) {
            this.initShim.maxFileSize(builder.maxFileSize);
        }
        if (builder.expectedCommitCountIsSet()) {
            this.initShim.expectedCommitCount(builder.expectedCommitCount);
        }
        if (builder.commitBatchSizeIsSet()) {
            this.initShim.commitBatchSize(builder.commitBatchSize);
        }
        if (builder.exportVersionIsSet()) {
            this.initShim.exportVersion(builder.exportVersion);
        }
        if (builder.progressListener != null) {
            this.initShim.progressListener(builder.progressListener);
        }
        this.commitLogic = this.initShim.commitLogic();
        this.referenceLogic = this.initShim.referenceLogic();
        this.repositoryLogic = this.initShim.repositoryLogic();
        this.indexesLogic = this.initShim.indexesLogic();
        this.fullScan = this.initShim.fullScan();
        this.contentsFromBranch = this.initShim.contentsFromBranch();
        this.contentsBatchSize = this.initShim.contentsBatchSize();
        this.objectMapper = this.initShim.objectMapper();
        this.storeWorker = this.initShim.storeWorker();
        this.outputBufferSize = this.initShim.outputBufferSize();
        this.maxFileSize = this.initShim.maxFileSize();
        this.expectedCommitCount = this.initShim.expectedCommitCount();
        this.commitBatchSize = this.initShim.commitBatchSize();
        this.exportVersion = this.initShim.exportVersion();
        this.progressListener = this.initShim.progressListener();
        this.initShim = null;
    }

    private ImmutableNessieExporter(Persist persist, CommitLogic commitLogic, ReferenceLogic referenceLogic, RepositoryLogic repositoryLogic, IndexesLogic indexesLogic, @Nullable VersionStore versionStore, boolean fullScan, @Nullable String contentsFromBranch, int contentsBatchSize, ObjectMapper objectMapper, StoreWorker storeWorker, int outputBufferSize, long maxFileSize, int expectedCommitCount, int commitBatchSize, int exportVersion, ExportFileSupplier exportFileSupplier, ProgressListener progressListener) {
        this.persist = persist;
        this.commitLogic = commitLogic;
        this.referenceLogic = referenceLogic;
        this.repositoryLogic = repositoryLogic;
        this.indexesLogic = indexesLogic;
        this.versionStore = versionStore;
        this.fullScan = fullScan;
        this.contentsFromBranch = contentsFromBranch;
        this.contentsBatchSize = contentsBatchSize;
        this.objectMapper = objectMapper;
        this.storeWorker = storeWorker;
        this.outputBufferSize = outputBufferSize;
        this.maxFileSize = maxFileSize;
        this.expectedCommitCount = expectedCommitCount;
        this.commitBatchSize = commitBatchSize;
        this.exportVersion = exportVersion;
        this.exportFileSupplier = exportFileSupplier;
        this.progressListener = progressListener;
        this.initShim = null;
    }

    @Override
    Persist persist() {
        return this.persist;
    }

    @Override
    CommitLogic commitLogic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.commitLogic() : this.commitLogic;
    }

    @Override
    ReferenceLogic referenceLogic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.referenceLogic() : this.referenceLogic;
    }

    @Override
    RepositoryLogic repositoryLogic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.repositoryLogic() : this.repositoryLogic;
    }

    @Override
    IndexesLogic indexesLogic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.indexesLogic() : this.indexesLogic;
    }

    @Override
    @Nullable
    VersionStore versionStore() {
        return this.versionStore;
    }

    @Override
    boolean fullScan() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fullScan() : this.fullScan;
    }

    @Override
    @Nullable
    String contentsFromBranch() {
        InitShim shim = this.initShim;
        return shim != null ? shim.contentsFromBranch() : this.contentsFromBranch;
    }

    @Override
    int contentsBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.contentsBatchSize() : this.contentsBatchSize;
    }

    @Override
    ObjectMapper objectMapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.objectMapper() : this.objectMapper;
    }

    @Override
    StoreWorker storeWorker() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storeWorker() : this.storeWorker;
    }

    @Override
    int outputBufferSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.outputBufferSize() : this.outputBufferSize;
    }

    @Override
    long maxFileSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxFileSize() : this.maxFileSize;
    }

    @Override
    int expectedCommitCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.expectedCommitCount() : this.expectedCommitCount;
    }

    @Override
    int commitBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.commitBatchSize() : this.commitBatchSize;
    }

    @Override
    int exportVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.exportVersion() : this.exportVersion;
    }

    @Override
    ExportFileSupplier exportFileSupplier() {
        return this.exportFileSupplier;
    }

    @Override
    ProgressListener progressListener() {
        InitShim shim = this.initShim;
        return shim != null ? shim.progressListener() : this.progressListener;
    }

    public final ImmutableNessieExporter withPersist(Persist value) {
        if (this.persist == value) {
            return this;
        }
        Persist newValue = Objects.requireNonNull(value, "persist");
        return new ImmutableNessieExporter(newValue, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withCommitLogic(CommitLogic value) {
        if (this.commitLogic == value) {
            return this;
        }
        CommitLogic newValue = Objects.requireNonNull(value, "commitLogic");
        return new ImmutableNessieExporter(this.persist, newValue, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withReferenceLogic(ReferenceLogic value) {
        if (this.referenceLogic == value) {
            return this;
        }
        ReferenceLogic newValue = Objects.requireNonNull(value, "referenceLogic");
        return new ImmutableNessieExporter(this.persist, this.commitLogic, newValue, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withRepositoryLogic(RepositoryLogic value) {
        if (this.repositoryLogic == value) {
            return this;
        }
        RepositoryLogic newValue = Objects.requireNonNull(value, "repositoryLogic");
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, newValue, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withIndexesLogic(IndexesLogic value) {
        if (this.indexesLogic == value) {
            return this;
        }
        IndexesLogic newValue = Objects.requireNonNull(value, "indexesLogic");
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, newValue, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withVersionStore(@Nullable VersionStore value) {
        if (this.versionStore == value) {
            return this;
        }
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, value, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withFullScan(boolean value) {
        if (this.fullScan == value) {
            return this;
        }
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, value, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withContentsFromBranch(@Nullable String value) {
        if (Objects.equals(this.contentsFromBranch, value)) {
            return this;
        }
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, value, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withContentsBatchSize(int value) {
        if (this.contentsBatchSize == value) {
            return this;
        }
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, value, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withObjectMapper(ObjectMapper value) {
        if (this.objectMapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "objectMapper");
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, newValue, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withStoreWorker(StoreWorker value) {
        if (this.storeWorker == value) {
            return this;
        }
        StoreWorker newValue = Objects.requireNonNull(value, "storeWorker");
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, newValue, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withOutputBufferSize(int value) {
        if (this.outputBufferSize == value) {
            return this;
        }
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, value, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withMaxFileSize(long value) {
        if (this.maxFileSize == value) {
            return this;
        }
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, value, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withExpectedCommitCount(int value) {
        if (this.expectedCommitCount == value) {
            return this;
        }
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, value, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withCommitBatchSize(int value) {
        if (this.commitBatchSize == value) {
            return this;
        }
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, value, this.exportVersion, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withExportVersion(int value) {
        if (this.exportVersion == value) {
            return this;
        }
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, value, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withExportFileSupplier(ExportFileSupplier value) {
        if (this.exportFileSupplier == value) {
            return this;
        }
        ExportFileSupplier newValue = Objects.requireNonNull(value, "exportFileSupplier");
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, newValue, this.progressListener);
    }

    public final ImmutableNessieExporter withProgressListener(ProgressListener value) {
        if (this.progressListener == value) {
            return this;
        }
        ProgressListener newValue = Objects.requireNonNull(value, "progressListener");
        return new ImmutableNessieExporter(this.persist, this.commitLogic, this.referenceLogic, this.repositoryLogic, this.indexesLogic, this.versionStore, this.fullScan, this.contentsFromBranch, this.contentsBatchSize, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.commitBatchSize, this.exportVersion, this.exportFileSupplier, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNessieExporter && this.equalTo(0, (ImmutableNessieExporter)another);
    }

    private boolean equalTo(int synthetic, ImmutableNessieExporter another) {
        return this.persist.equals(another.persist) && this.commitLogic.equals(another.commitLogic) && this.referenceLogic.equals(another.referenceLogic) && this.repositoryLogic.equals(another.repositoryLogic) && this.indexesLogic.equals(another.indexesLogic) && Objects.equals(this.versionStore, another.versionStore) && this.fullScan == another.fullScan && Objects.equals(this.contentsFromBranch, another.contentsFromBranch) && this.contentsBatchSize == another.contentsBatchSize && this.objectMapper.equals(another.objectMapper) && this.storeWorker.equals(another.storeWorker) && this.outputBufferSize == another.outputBufferSize && this.maxFileSize == another.maxFileSize && this.expectedCommitCount == another.expectedCommitCount && this.commitBatchSize == another.commitBatchSize && this.exportVersion == another.exportVersion && this.exportFileSupplier.equals(another.exportFileSupplier) && this.progressListener.equals(another.progressListener);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.persist.hashCode();
        h += (h << 5) + this.commitLogic.hashCode();
        h += (h << 5) + this.referenceLogic.hashCode();
        h += (h << 5) + this.repositoryLogic.hashCode();
        h += (h << 5) + this.indexesLogic.hashCode();
        h += (h << 5) + Objects.hashCode(this.versionStore);
        h += (h << 5) + Booleans.hashCode((boolean)this.fullScan);
        h += (h << 5) + Objects.hashCode(this.contentsFromBranch);
        h += (h << 5) + this.contentsBatchSize;
        h += (h << 5) + this.objectMapper.hashCode();
        h += (h << 5) + this.storeWorker.hashCode();
        h += (h << 5) + this.outputBufferSize;
        h += (h << 5) + Longs.hashCode((long)this.maxFileSize);
        h += (h << 5) + this.expectedCommitCount;
        h += (h << 5) + this.commitBatchSize;
        h += (h << 5) + this.exportVersion;
        h += (h << 5) + this.exportFileSupplier.hashCode();
        h += (h << 5) + this.progressListener.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NessieExporter").omitNullValues().add("persist", (Object)this.persist).add("commitLogic", (Object)this.commitLogic).add("referenceLogic", (Object)this.referenceLogic).add("repositoryLogic", (Object)this.repositoryLogic).add("indexesLogic", (Object)this.indexesLogic).add("versionStore", (Object)this.versionStore).add("fullScan", this.fullScan).add("contentsFromBranch", (Object)this.contentsFromBranch).add("contentsBatchSize", this.contentsBatchSize).add("objectMapper", (Object)this.objectMapper).add("storeWorker", (Object)this.storeWorker).add("outputBufferSize", this.outputBufferSize).add("maxFileSize", this.maxFileSize).add("expectedCommitCount", this.expectedCommitCount).add("commitBatchSize", this.commitBatchSize).add("exportVersion", this.exportVersion).add("exportFileSupplier", (Object)this.exportFileSupplier).add("progressListener", (Object)this.progressListener).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Clock clock() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableNessieExporter immutableNessieExporter = this;
            synchronized (immutableNessieExporter) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.clock = Objects.requireNonNull(super.clock(), "clock");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.clock;
    }

    public static ImmutableNessieExporter copyOf(NessieExporter instance) {
        if (instance instanceof ImmutableNessieExporter) {
            return (ImmutableNessieExporter)instance;
        }
        return ImmutableNessieExporter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NessieExporter", generator="Immutables")
    private final class InitShim {
        private byte commitLogicBuildStage = 0;
        private CommitLogic commitLogic;
        private byte referenceLogicBuildStage = 0;
        private ReferenceLogic referenceLogic;
        private byte repositoryLogicBuildStage = 0;
        private RepositoryLogic repositoryLogic;
        private byte indexesLogicBuildStage = 0;
        private IndexesLogic indexesLogic;
        private byte fullScanBuildStage = 0;
        private boolean fullScan;
        private byte contentsFromBranchBuildStage = 0;
        private String contentsFromBranch;
        private byte contentsBatchSizeBuildStage = 0;
        private int contentsBatchSize;
        private byte objectMapperBuildStage = 0;
        private ObjectMapper objectMapper;
        private byte storeWorkerBuildStage = 0;
        private StoreWorker storeWorker;
        private byte outputBufferSizeBuildStage = 0;
        private int outputBufferSize;
        private byte maxFileSizeBuildStage = 0;
        private long maxFileSize;
        private byte expectedCommitCountBuildStage = 0;
        private int expectedCommitCount;
        private byte commitBatchSizeBuildStage = 0;
        private int commitBatchSize;
        private byte exportVersionBuildStage = 0;
        private int exportVersion;
        private byte progressListenerBuildStage = 0;
        private ProgressListener progressListener;

        private InitShim() {
        }

        CommitLogic commitLogic() {
            if (this.commitLogicBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitLogicBuildStage == 0) {
                this.commitLogicBuildStage = (byte)-1;
                this.commitLogic = Objects.requireNonNull(ImmutableNessieExporter.super.commitLogic(), "commitLogic");
                this.commitLogicBuildStage = 1;
            }
            return this.commitLogic;
        }

        void commitLogic(CommitLogic commitLogic) {
            this.commitLogic = commitLogic;
            this.commitLogicBuildStage = 1;
        }

        ReferenceLogic referenceLogic() {
            if (this.referenceLogicBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.referenceLogicBuildStage == 0) {
                this.referenceLogicBuildStage = (byte)-1;
                this.referenceLogic = Objects.requireNonNull(ImmutableNessieExporter.super.referenceLogic(), "referenceLogic");
                this.referenceLogicBuildStage = 1;
            }
            return this.referenceLogic;
        }

        void referenceLogic(ReferenceLogic referenceLogic) {
            this.referenceLogic = referenceLogic;
            this.referenceLogicBuildStage = 1;
        }

        RepositoryLogic repositoryLogic() {
            if (this.repositoryLogicBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.repositoryLogicBuildStage == 0) {
                this.repositoryLogicBuildStage = (byte)-1;
                this.repositoryLogic = Objects.requireNonNull(ImmutableNessieExporter.super.repositoryLogic(), "repositoryLogic");
                this.repositoryLogicBuildStage = 1;
            }
            return this.repositoryLogic;
        }

        void repositoryLogic(RepositoryLogic repositoryLogic) {
            this.repositoryLogic = repositoryLogic;
            this.repositoryLogicBuildStage = 1;
        }

        IndexesLogic indexesLogic() {
            if (this.indexesLogicBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indexesLogicBuildStage == 0) {
                this.indexesLogicBuildStage = (byte)-1;
                this.indexesLogic = Objects.requireNonNull(ImmutableNessieExporter.super.indexesLogic(), "indexesLogic");
                this.indexesLogicBuildStage = 1;
            }
            return this.indexesLogic;
        }

        void indexesLogic(IndexesLogic indexesLogic) {
            this.indexesLogic = indexesLogic;
            this.indexesLogicBuildStage = 1;
        }

        boolean fullScan() {
            if (this.fullScanBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fullScanBuildStage == 0) {
                this.fullScanBuildStage = (byte)-1;
                this.fullScan = ImmutableNessieExporter.super.fullScan();
                this.fullScanBuildStage = 1;
            }
            return this.fullScan;
        }

        void fullScan(boolean fullScan) {
            this.fullScan = fullScan;
            this.fullScanBuildStage = 1;
        }

        String contentsFromBranch() {
            if (this.contentsFromBranchBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contentsFromBranchBuildStage == 0) {
                this.contentsFromBranchBuildStage = (byte)-1;
                this.contentsFromBranch = ImmutableNessieExporter.super.contentsFromBranch();
                this.contentsFromBranchBuildStage = 1;
            }
            return this.contentsFromBranch;
        }

        void contentsFromBranch(String contentsFromBranch) {
            this.contentsFromBranch = contentsFromBranch;
            this.contentsFromBranchBuildStage = 1;
        }

        int contentsBatchSize() {
            if (this.contentsBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contentsBatchSizeBuildStage == 0) {
                this.contentsBatchSizeBuildStage = (byte)-1;
                this.contentsBatchSize = ImmutableNessieExporter.super.contentsBatchSize();
                this.contentsBatchSizeBuildStage = 1;
            }
            return this.contentsBatchSize;
        }

        void contentsBatchSize(int contentsBatchSize) {
            this.contentsBatchSize = contentsBatchSize;
            this.contentsBatchSizeBuildStage = 1;
        }

        ObjectMapper objectMapper() {
            if (this.objectMapperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMapperBuildStage == 0) {
                this.objectMapperBuildStage = (byte)-1;
                this.objectMapper = Objects.requireNonNull(ImmutableNessieExporter.super.objectMapper(), "objectMapper");
                this.objectMapperBuildStage = 1;
            }
            return this.objectMapper;
        }

        void objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectMapperBuildStage = 1;
        }

        StoreWorker storeWorker() {
            if (this.storeWorkerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storeWorkerBuildStage == 0) {
                this.storeWorkerBuildStage = (byte)-1;
                this.storeWorker = Objects.requireNonNull(ImmutableNessieExporter.super.storeWorker(), "storeWorker");
                this.storeWorkerBuildStage = 1;
            }
            return this.storeWorker;
        }

        void storeWorker(StoreWorker storeWorker) {
            this.storeWorker = storeWorker;
            this.storeWorkerBuildStage = 1;
        }

        int outputBufferSize() {
            if (this.outputBufferSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputBufferSizeBuildStage == 0) {
                this.outputBufferSizeBuildStage = (byte)-1;
                this.outputBufferSize = ImmutableNessieExporter.super.outputBufferSize();
                this.outputBufferSizeBuildStage = 1;
            }
            return this.outputBufferSize;
        }

        void outputBufferSize(int outputBufferSize) {
            this.outputBufferSize = outputBufferSize;
            this.outputBufferSizeBuildStage = 1;
        }

        long maxFileSize() {
            if (this.maxFileSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxFileSizeBuildStage == 0) {
                this.maxFileSizeBuildStage = (byte)-1;
                this.maxFileSize = ImmutableNessieExporter.super.maxFileSize();
                this.maxFileSizeBuildStage = 1;
            }
            return this.maxFileSize;
        }

        void maxFileSize(long maxFileSize) {
            this.maxFileSize = maxFileSize;
            this.maxFileSizeBuildStage = 1;
        }

        int expectedCommitCount() {
            if (this.expectedCommitCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.expectedCommitCountBuildStage == 0) {
                this.expectedCommitCountBuildStage = (byte)-1;
                this.expectedCommitCount = ImmutableNessieExporter.super.expectedCommitCount();
                this.expectedCommitCountBuildStage = 1;
            }
            return this.expectedCommitCount;
        }

        void expectedCommitCount(int expectedCommitCount) {
            this.expectedCommitCount = expectedCommitCount;
            this.expectedCommitCountBuildStage = 1;
        }

        int commitBatchSize() {
            if (this.commitBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitBatchSizeBuildStage == 0) {
                this.commitBatchSizeBuildStage = (byte)-1;
                this.commitBatchSize = ImmutableNessieExporter.super.commitBatchSize();
                this.commitBatchSizeBuildStage = 1;
            }
            return this.commitBatchSize;
        }

        void commitBatchSize(int commitBatchSize) {
            this.commitBatchSize = commitBatchSize;
            this.commitBatchSizeBuildStage = 1;
        }

        int exportVersion() {
            if (this.exportVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.exportVersionBuildStage == 0) {
                this.exportVersionBuildStage = (byte)-1;
                this.exportVersion = ImmutableNessieExporter.super.exportVersion();
                this.exportVersionBuildStage = 1;
            }
            return this.exportVersion;
        }

        void exportVersion(int exportVersion) {
            this.exportVersion = exportVersion;
            this.exportVersionBuildStage = 1;
        }

        ProgressListener progressListener() {
            if (this.progressListenerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.progressListenerBuildStage == 0) {
                this.progressListenerBuildStage = (byte)-1;
                this.progressListener = Objects.requireNonNull(ImmutableNessieExporter.super.progressListener(), "progressListener");
                this.progressListenerBuildStage = 1;
            }
            return this.progressListener;
        }

        void progressListener(ProgressListener progressListener) {
            this.progressListener = progressListener;
            this.progressListenerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.commitLogicBuildStage == -1) {
                attributes.add("commitLogic");
            }
            if (this.referenceLogicBuildStage == -1) {
                attributes.add("referenceLogic");
            }
            if (this.repositoryLogicBuildStage == -1) {
                attributes.add("repositoryLogic");
            }
            if (this.indexesLogicBuildStage == -1) {
                attributes.add("indexesLogic");
            }
            if (this.fullScanBuildStage == -1) {
                attributes.add("fullScan");
            }
            if (this.contentsFromBranchBuildStage == -1) {
                attributes.add("contentsFromBranch");
            }
            if (this.contentsBatchSizeBuildStage == -1) {
                attributes.add("contentsBatchSize");
            }
            if (this.objectMapperBuildStage == -1) {
                attributes.add("objectMapper");
            }
            if (this.storeWorkerBuildStage == -1) {
                attributes.add("storeWorker");
            }
            if (this.outputBufferSizeBuildStage == -1) {
                attributes.add("outputBufferSize");
            }
            if (this.maxFileSizeBuildStage == -1) {
                attributes.add("maxFileSize");
            }
            if (this.expectedCommitCountBuildStage == -1) {
                attributes.add("expectedCommitCount");
            }
            if (this.commitBatchSizeBuildStage == -1) {
                attributes.add("commitBatchSize");
            }
            if (this.exportVersionBuildStage == -1) {
                attributes.add("exportVersion");
            }
            if (this.progressListenerBuildStage == -1) {
                attributes.add("progressListener");
            }
            return "Cannot build NessieExporter, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="NessieExporter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements NessieExporter.Builder {
        private static final long INIT_BIT_PERSIST = 1L;
        private static final long INIT_BIT_EXPORT_FILE_SUPPLIER = 2L;
        private static final long OPT_BIT_FULL_SCAN = 1L;
        private static final long OPT_BIT_CONTENTS_FROM_BRANCH = 2L;
        private static final long OPT_BIT_CONTENTS_BATCH_SIZE = 4L;
        private static final long OPT_BIT_OUTPUT_BUFFER_SIZE = 8L;
        private static final long OPT_BIT_MAX_FILE_SIZE = 16L;
        private static final long OPT_BIT_EXPECTED_COMMIT_COUNT = 32L;
        private static final long OPT_BIT_COMMIT_BATCH_SIZE = 64L;
        private static final long OPT_BIT_EXPORT_VERSION = 128L;
        private long initBits = 3L;
        private long optBits;
        @javax.annotation.Nullable
        private Persist persist;
        @javax.annotation.Nullable
        private CommitLogic commitLogic;
        @javax.annotation.Nullable
        private ReferenceLogic referenceLogic;
        @javax.annotation.Nullable
        private RepositoryLogic repositoryLogic;
        @javax.annotation.Nullable
        private IndexesLogic indexesLogic;
        @javax.annotation.Nullable
        private VersionStore versionStore;
        private boolean fullScan;
        @javax.annotation.Nullable
        private String contentsFromBranch;
        private int contentsBatchSize;
        @javax.annotation.Nullable
        private ObjectMapper objectMapper;
        @javax.annotation.Nullable
        private StoreWorker storeWorker;
        private int outputBufferSize;
        private long maxFileSize;
        private int expectedCommitCount;
        private int commitBatchSize;
        private int exportVersion;
        @javax.annotation.Nullable
        private ExportFileSupplier exportFileSupplier;
        @javax.annotation.Nullable
        private ProgressListener progressListener;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NessieExporter instance) {
            Objects.requireNonNull(instance, "instance");
            this.persist(instance.persist());
            this.commitLogic(instance.commitLogic());
            this.referenceLogic(instance.referenceLogic());
            this.repositoryLogic(instance.repositoryLogic());
            this.indexesLogic(instance.indexesLogic());
            VersionStore versionStoreValue = instance.versionStore();
            if (versionStoreValue != null) {
                this.versionStore(versionStoreValue);
            }
            this.fullScan(instance.fullScan());
            String contentsFromBranchValue = instance.contentsFromBranch();
            if (contentsFromBranchValue != null) {
                this.contentsFromBranch(contentsFromBranchValue);
            }
            this.contentsBatchSize(instance.contentsBatchSize());
            this.objectMapper(instance.objectMapper());
            this.storeWorker(instance.storeWorker());
            this.outputBufferSize(instance.outputBufferSize());
            this.maxFileSize(instance.maxFileSize());
            this.expectedCommitCount(instance.expectedCommitCount());
            this.commitBatchSize(instance.commitBatchSize());
            this.exportVersion(instance.exportVersion());
            this.exportFileSupplier(instance.exportFileSupplier());
            this.progressListener(instance.progressListener());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder persist(Persist persist) {
            this.persist = Objects.requireNonNull(persist, "persist");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder commitLogic(CommitLogic commitLogic) {
            this.commitLogic = Objects.requireNonNull(commitLogic, "commitLogic");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder referenceLogic(ReferenceLogic referenceLogic) {
            this.referenceLogic = Objects.requireNonNull(referenceLogic, "referenceLogic");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder repositoryLogic(RepositoryLogic repositoryLogic) {
            this.repositoryLogic = Objects.requireNonNull(repositoryLogic, "repositoryLogic");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder indexesLogic(IndexesLogic indexesLogic) {
            this.indexesLogic = Objects.requireNonNull(indexesLogic, "indexesLogic");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder versionStore(@Nullable VersionStore versionStore) {
            this.versionStore = versionStore;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder fullScan(boolean fullScan) {
            this.fullScan = fullScan;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder contentsFromBranch(@Nullable String contentsFromBranch) {
            this.contentsFromBranch = contentsFromBranch;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder contentsBatchSize(int contentsBatchSize) {
            this.contentsBatchSize = contentsBatchSize;
            this.optBits |= 4L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder storeWorker(StoreWorker storeWorker) {
            this.storeWorker = Objects.requireNonNull(storeWorker, "storeWorker");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder outputBufferSize(int outputBufferSize) {
            this.outputBufferSize = outputBufferSize;
            this.optBits |= 8L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder maxFileSize(long maxFileSize) {
            this.maxFileSize = maxFileSize;
            this.optBits |= 0x10L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder expectedCommitCount(int expectedCommitCount) {
            this.expectedCommitCount = expectedCommitCount;
            this.optBits |= 0x20L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder commitBatchSize(int commitBatchSize) {
            this.commitBatchSize = commitBatchSize;
            this.optBits |= 0x40L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder exportVersion(int exportVersion) {
            this.exportVersion = exportVersion;
            this.optBits |= 0x80L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder exportFileSupplier(ExportFileSupplier exportFileSupplier) {
            this.exportFileSupplier = Objects.requireNonNull(exportFileSupplier, "exportFileSupplier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder progressListener(ProgressListener progressListener) {
            this.progressListener = Objects.requireNonNull(progressListener, "progressListener");
            return this;
        }

        @Override
        public ImmutableNessieExporter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNessieExporter(this);
        }

        private boolean fullScanIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean contentsFromBranchIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean contentsBatchSizeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean outputBufferSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean maxFileSizeIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean expectedCommitCountIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean commitBatchSizeIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean exportVersionIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("persist");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("exportFileSupplier");
            }
            return "Cannot build NessieExporter, some of required attributes are not set " + attributes;
        }
    }
}

