/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.UUID;
import org.projectnessie.model.Content;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.batching.BatchingPersist;
import org.projectnessie.versioned.storage.batching.WriteBatching;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RetryTimeoutException;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.ImmutableRepositoryDescription;
import org.projectnessie.versioned.storage.common.logic.RepositoryDescription;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.ContentValueObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.transfer.ImportCommon;
import org.projectnessie.versioned.transfer.ImportResult;
import org.projectnessie.versioned.transfer.NessieImporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

abstract class ImportPersistCommon
extends ImportCommon {
    protected final BatchingPersist persist;

    ImportPersistCommon(TransferTypes.ExportMeta exportMeta, NessieImporter importer) {
        super(exportMeta, importer);
        this.persist = WriteBatching.builder().persist(Objects.requireNonNull(importer.persist())).batchSize(importer.commitBatchSize()).optimistic(true).build().create();
    }

    @Override
    ImportResult importRepo() throws IOException {
        try {
            ImportResult importResult = super.importRepo();
            return importResult;
        }
        finally {
            this.persist.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void importFinalize(TransferTypes.HeadsAndForks headsAndForks) {
        try {
            for (ByteString head : headsAndForks.getHeadsList()) {
                try {
                    this.importer.indexesLogic().completeIndexesInCommitChain(ObjId.objIdFromBytes((ByteString)head), () -> this.importer.progressListener().progress(ProgressEvent.FINALIZE_PROGRESS));
                }
                catch (ObjNotFoundException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            this.persist.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    long importCommits() throws IOException {
        long commitCount = 0L;
        try {
            for (String fileName : this.exportMeta.getCommitsFilesList()) {
                try {
                    InputStream input = this.importFiles.newFileInput(fileName);
                    try {
                        TransferTypes.Commit commit;
                        while ((commit = TransferTypes.Commit.parseDelimitedFrom((InputStream)input)) != null) {
                            this.processCommit(commit);
                            ++commitCount;
                        }
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
                catch (ObjTooLargeException e) {
                    throw new RuntimeException(e);
                    return commitCount;
                }
            }
        }
        finally {
            this.persist.flush();
        }
    }

    @Override
    void markRepositoryImported() {
        RepositoryDescription initialDescription = Objects.requireNonNull(this.importer.repositoryLogic().fetchRepositoryDescription());
        ImmutableRepositoryDescription updatedDescription = ImmutableRepositoryDescription.builder().from(initialDescription).repositoryImportedTime(this.importer.persist().config().clock().instant()).build();
        try {
            this.importer.repositoryLogic().updateRepositoryDescription((RepositoryDescription)updatedDescription);
        }
        catch (RetryTimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    abstract void processCommit(TransferTypes.Commit var1) throws IOException, ObjTooLargeException;

    void processCommitOp(StoreIndex<CommitOp> index, TransferTypes.Operation op, StoreKey storeKey) {
        byte payload = (byte)op.getPayload();
        switch (op.getOperationType()) {
            case Delete: {
                index.add(StoreIndexElement.indexElement((StoreKey)storeKey, (Object)CommitOp.commitOp((CommitOp.Action)CommitOp.Action.REMOVE, (int)payload, null, (UUID)CommitOp.contentIdMaybe((String)op.getContentId()))));
                break;
            }
            case Put: {
                try (InputStream inValue = op.getValue().newInput();){
                    Content content = (Content)this.importer.objectMapper().readValue(inValue, Content.class);
                    ByteString onRef = this.importer.storeWorker().toStoreOnReferenceState(content);
                    ContentValueObj value = ContentValueObj.contentValue((String)op.getContentId(), (int)payload, (ByteString)onRef);
                    this.persist.storeObj((Obj)value);
                    index.add(StoreIndexElement.indexElement((StoreKey)storeKey, (Object)CommitOp.commitOp((CommitOp.Action)CommitOp.Action.ADD, (int)payload, (ObjId)value.id(), (UUID)CommitOp.contentIdMaybe((String)op.getContentId()))));
                    break;
                }
                catch (IOException | ObjTooLargeException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown operation type " + op);
            }
        }
    }
}

