/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RetryTimeoutException;
import org.projectnessie.versioned.storage.common.indexes.ElementSerializer;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexes;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.versionstore.TypeMapping;
import org.projectnessie.versioned.transfer.ImportPersistCommon;
import org.projectnessie.versioned.transfer.NessieImporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

final class ImportPersistV1
extends ImportPersistCommon {
    ImportPersistV1(TransferTypes.ExportMeta exportMeta, NessieImporter importer) {
        super(exportMeta, importer);
    }

    @Override
    void prepareRepository() {
        this.importer.repositoryLogic().initialize("main", false, b -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long importNamedReferences() throws IOException {
        try {
            long namedReferenceCount = 0L;
            for (String fileName : this.exportMeta.getNamedReferencesFilesList()) {
                InputStream input = this.importFiles.newFileInput(fileName);
                try {
                    TransferTypes.NamedReference namedReference;
                    while ((namedReference = TransferTypes.NamedReference.parseDelimitedFrom((InputStream)input)) != null) {
                        String ref;
                        switch (namedReference.getRefType()) {
                            case Tag: {
                                ref = "refs/tags/" + namedReference.getName();
                                break;
                            }
                            case Branch: {
                                ref = "refs/heads/" + namedReference.getName();
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown reference type " + namedReference);
                            }
                        }
                        try {
                            this.importer.referenceLogic().createReference(ref, ObjId.objIdFromBytes((ByteString)namedReference.getCommitId()), null);
                        }
                        catch (RefAlreadyExistsException | RetryTimeoutException e) {
                            throw new RuntimeException(e);
                        }
                        ++namedReferenceCount;
                        this.importer.progressListener().progress(ProgressEvent.NAMED_REFERENCE_WRITTEN);
                    }
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            long l = namedReferenceCount;
            return l;
        }
        finally {
            this.persist.flush();
        }
    }

    @Override
    void processCommit(TransferTypes.Commit commit) throws IOException, ObjTooLargeException {
        CommitMeta metadata;
        try (InputStream in = commit.getMetadata().newInput();){
            metadata = (CommitMeta)this.importer.objectMapper().readValue(in, CommitMeta.class);
        }
        CommitObj.Builder c = CommitObj.commitBuilder().id(ObjId.objIdFromBytes((ByteString)commit.getCommitId())).addTail(ObjId.objIdFromBytes((ByteString)commit.getParentCommitId())).created(commit.getCreatedTimeMicros()).seq(commit.getCommitSequence()).message(metadata.getMessage()).headers(TypeMapping.headersFromCommitMeta((CommitMeta)metadata)).incompleteIndex(true);
        commit.getAdditionalParentsList().forEach(ap -> c.addSecondaryParents(ObjId.objIdFromBytes((ByteString)ap)));
        StoreIndex index = StoreIndexes.newStoreIndex((ElementSerializer)CommitOp.COMMIT_OP_SERIALIZER);
        commit.getOperationsList().forEach(op -> {
            StoreKey storeKey = TypeMapping.keyToStoreKey((ContentKey)ContentKey.of((List)op.getContentKeyList()));
            this.processCommitOp((StoreIndex<CommitOp>)index, (TransferTypes.Operation)op, storeKey);
        });
        c.incrementalIndex(index.serialize());
        this.persist.storeObj((Obj)c.build());
        this.importer.progressListener().progress(ProgressEvent.COMMIT_WRITTEN);
    }
}

