/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.immutables.value.Value;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.storage.common.logic.IndexesLogic;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.ReferenceLogic;
import org.projectnessie.versioned.storage.common.logic.RepositoryLogic;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.transfer.ImmutableNessieImporter;
import org.projectnessie.versioned.transfer.ImportPersistV1;
import org.projectnessie.versioned.transfer.ImportPersistV2;
import org.projectnessie.versioned.transfer.ImportResult;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.ProgressListener;
import org.projectnessie.versioned.transfer.files.ImportFileSupplier;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

@Value.Immutable
public abstract class NessieImporter {
    public static Builder builder() {
        return ImmutableNessieImporter.builder();
    }

    abstract Persist persist();

    @Value.Default
    ReferenceLogic referenceLogic() {
        return Logics.referenceLogic((Persist)this.persist());
    }

    @Value.Default
    RepositoryLogic repositoryLogic() {
        return Logics.repositoryLogic((Persist)this.persist());
    }

    @Value.Default
    IndexesLogic indexesLogic() {
        return Logics.indexesLogic((Persist)this.persist());
    }

    @Value.Default
    int commitBatchSize() {
        return 20;
    }

    @Value.Default
    int attachmentBatchSize() {
        return 20;
    }

    @Value.Default
    StoreWorker storeWorker() {
        return DefaultStoreWorker.instance();
    }

    @Value.Default
    ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Value.Default
    ProgressListener progressListener() {
        return (x, y) -> {};
    }

    abstract ImportFileSupplier importFileSupplier();

    public TransferTypes.RepositoryDescriptionProto loadRepositoryDescription() throws IOException {
        try (InputStream input = this.importFileSupplier().newFileInput("repository-description");){
            TransferTypes.RepositoryDescriptionProto repositoryDescriptionProto = TransferTypes.RepositoryDescriptionProto.parseFrom((InputStream)input);
            return repositoryDescriptionProto;
        }
    }

    public TransferTypes.HeadsAndForks loadHeadsAndForks() throws IOException {
        try (InputStream input = this.importFileSupplier().newFileInput("heads-and-forks");){
            TransferTypes.HeadsAndForks headsAndForks = TransferTypes.HeadsAndForks.parseFrom((InputStream)input);
            return headsAndForks;
        }
    }

    public ImportResult importNessieRepository() throws IOException {
        this.progressListener().progress(ProgressEvent.STARTED);
        this.progressListener().progress(ProgressEvent.START_META);
        TransferTypes.ExportMeta exportMeta = this.loadExportMeta();
        this.progressListener().progress(ProgressEvent.END_META, exportMeta);
        switch (exportMeta.getVersion()) {
            case V1: {
                return new ImportPersistV1(exportMeta, this).importRepo();
            }
            case V2: {
                return new ImportPersistV2(exportMeta, this).importRepo();
            }
        }
        throw new IllegalStateException(String.format("This Nessie version does not support importing a %s (%d) export", exportMeta.getVersion().name(), exportMeta.getVersionValue()));
    }

    private TransferTypes.ExportMeta loadExportMeta() throws IOException {
        TransferTypes.ExportMeta exportMeta;
        try (InputStream input = this.importFileSupplier().newFileInput("export-metadata");){
            exportMeta = TransferTypes.ExportMeta.parseFrom((InputStream)input);
        }
        return exportMeta;
    }

    public static interface Builder {
        public Builder persist(Persist var1);

        public Builder referenceLogic(ReferenceLogic var1);

        public Builder repositoryLogic(RepositoryLogic var1);

        public Builder indexesLogic(IndexesLogic var1);

        public Builder objectMapper(ObjectMapper var1);

        public Builder storeWorker(StoreWorker var1);

        public Builder commitBatchSize(int var1);

        public Builder attachmentBatchSize(int var1);

        public Builder progressListener(ProgressListener var1);

        public Builder importFileSupplier(ImportFileSupplier var1);

        public NessieImporter build();
    }
}

