/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.projectnessie.nessie.relocated.protobuf.AbstractMessage;
import org.projectnessie.versioned.transfer.NessieExporter;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;

final class SizeLimitedOutput {
    private final ExportFileSupplier exportFiles;
    private final String fileNamePrefix;
    private final Consumer<String> newFileName;
    private final LongConsumer finalEntityCount;
    private final long maxFileSize;
    private final int outputBufferSize;
    private int fileNum;
    long entityCount;
    private long currentFileSize;
    private OutputStream output;

    SizeLimitedOutput(ExportFileSupplier exportFiles, NessieExporter exporter, String fileNamePrefix, Consumer<String> newFileName, LongConsumer finalEntityCount) {
        this.exportFiles = exportFiles;
        this.maxFileSize = exporter.maxFileSize();
        this.outputBufferSize = exporter.outputBufferSize();
        this.fileNamePrefix = fileNamePrefix;
        this.newFileName = newFileName;
        this.finalEntityCount = finalEntityCount;
    }

    void writeEntity(AbstractMessage message) {
        try {
            int size = message.getSerializedSize();
            this.currentFileSize += (long)size;
            if (this.maxFileSize != Long.MAX_VALUE && this.currentFileSize > this.maxFileSize) {
                this.currentFileSize = 0L;
                this.finishCurrentFile();
            }
            if (this.output == null) {
                ++this.fileNum;
                String fileName = String.format("%s-%08d", this.fileNamePrefix, this.fileNum);
                this.output = new BufferedOutputStream(this.exportFiles.newFileOutput(fileName), this.outputBufferSize);
                this.newFileName.accept(fileName);
            }
            message.writeDelimitedTo(this.output);
            ++this.entityCount;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void finish() throws IOException {
        this.finishCurrentFile();
        this.finalEntityCount.accept(this.entityCount);
    }

    void finishCurrentFile() throws IOException {
        if (this.output != null) {
            try {
                this.output.flush();
                this.output.close();
            }
            finally {
                this.output = null;
            }
        }
    }

    public void closeSilently() {
        try {
            this.finishCurrentFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

