/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer.files;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.immutables.value.Value;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.files.ImmutableZipArchiveExporter;

@Value.Immutable
public abstract class ZipArchiveExporter
implements ExportFileSupplier {
    public static Builder builder() {
        return ImmutableZipArchiveExporter.builder();
    }

    abstract Path outputFile();

    @Value.Lazy
    Path tempOutputFile() {
        Path out = this.outputFile();
        return out.resolveSibling("." + out.getFileName().toString() + ".tmp");
    }

    @Value.Lazy
    ZipOutputStream zipOutput() throws IOException {
        Path parent = this.outputFile().getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        return new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(this.tempOutputFile(), new OpenOption[0])));
    }

    @Override
    public void preValidate() {
    }

    @Override
    @Nonnull
    public Path getTargetPath() {
        return this.outputFile();
    }

    @Override
    @Nonnull
    public OutputStream newFileOutput(@Nonnull String fileName) throws IOException {
        Preconditions.checkArgument((fileName.indexOf(47) == -1 && fileName.indexOf(92) == -1 ? 1 : 0) != 0, (Object)"Directories not supported");
        Preconditions.checkArgument((!fileName.isEmpty() ? 1 : 0) != 0, (Object)"Invalid file name argument");
        ZipOutputStream out = this.zipOutput();
        out.putNextEntry(new ZipEntry(fileName));
        return new NonClosingOutputStream(out);
    }

    @Override
    public void close() throws Exception {
        try {
            this.zipOutput().close();
        }
        finally {
            Files.deleteIfExists(this.outputFile());
            if (Files.isRegularFile(this.tempOutputFile(), new LinkOption[0])) {
                Files.move(this.tempOutputFile(), this.outputFile(), new CopyOption[0]);
            }
        }
    }

    private static final class NonClosingOutputStream
    extends OutputStream {
        private final ZipOutputStream out;
        private boolean open = true;

        private NonClosingOutputStream(ZipOutputStream out) {
            this.out = out;
        }

        @Override
        public void write(byte[] b) throws IOException {
            Preconditions.checkState((boolean)this.open);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Preconditions.checkState((boolean)this.open);
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            Preconditions.checkState((boolean)this.open);
            this.out.write(b);
        }

        @Override
        public void flush() throws IOException {
            Preconditions.checkState((boolean)this.open);
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.open) {
                try {
                    this.out.closeEntry();
                }
                finally {
                    this.open = false;
                }
            }
        }
    }

    public static interface Builder {
        public Builder outputFile(Path var1);

        public ZipArchiveExporter build();
    }
}

