/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import prompto.intrinsic.PromptoStorableBase;
import prompto.intrinsic.PromptoVersion;
import prompto.runtime.Context;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;

public class Dependency
extends PromptoStorableBase {
    private String name;
    private PromptoVersion version;

    public static List<Dependency> listFromStored(IStore store, Object data) {
        if (!(data instanceof Collection)) {
            return null;
        }
        return ((Collection)data).stream().map(dbId -> Dependency.fromStored(store, dbId)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Dependency fromStored(IStore store, Object data) {
        IStored stored = store.fetchUnique(data);
        if (stored == null) {
            return null;
        }
        Dependency result = new Dependency();
        result.fromStored(stored);
        return result;
    }

    public Dependency() {
    }

    public Dependency(String name, PromptoVersion version) {
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PromptoVersion getVersion() {
        return this.version;
    }

    public void setVersion(PromptoVersion version) {
        this.version = version;
    }

    public IStorable collectStorables(Context context, IStore store, List<IStorable> storables) {
        List<String> categories = Arrays.asList("Dependency");
        IStorable storable = store.newStorable(categories, this.getDbIdFactory());
        storables.add(storable);
        storable.setData("name", this.name);
        storable.setData("version", this.version);
        return storable;
    }

    private void fromStored(IStored stored) {
        this.setDbId(stored.getDbId());
        this.setName((String)stored.getData("name"));
        this.setVersion((PromptoVersion)stored.getData("version"));
    }
}

