/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import prompto.code.Batch;
import prompto.code.Dependency;
import prompto.code.Library;
import prompto.code.Module;
import prompto.code.ModuleType;
import prompto.code.Resource;
import prompto.code.Script;
import prompto.code.Service;
import prompto.code.WebSite;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.DeclarationList;
import prompto.declaration.IDeclaration;
import prompto.error.PromptoError;
import prompto.intrinsic.PromptoVersion;
import prompto.parser.AbstractParser;
import prompto.parser.Dialect;
import prompto.parser.ECleverParser;
import prompto.parser.ISection;
import prompto.parser.MCleverParser;
import prompto.parser.OCleverParser;
import prompto.runtime.Context;
import prompto.store.AttributeInfo;
import prompto.utils.ISingleton;

public interface ICodeStore {
    public static final ISingleton<ICodeStore> instance = new ISingleton<ICodeStore>(){
        ICodeStore instance = null;

        @Override
        public void set(ICodeStore instance) {
            this.instance = instance;
        }

        @Override
        public ICodeStore get() {
            return this.instance;
        }
    };
    public static final Set<Object> moduleDbIds = new HashSet<Object>();
    public static final Set<String> CODE_EXTENSIONS = new HashSet<String>(Arrays.asList("pec", "poc", "pmc"));

    public static void setInstance(ICodeStore store) {
        instance.set(store);
    }

    public static ICodeStore getInstance() {
        return instance.get();
    }

    public static void addModuleDbId(Object dbId) {
        moduleDbIds.add(dbId);
    }

    public static Set<Object> getModuleDbIds() {
        return moduleDbIds;
    }

    public static DeclarationList parse(String sourceName, InputStream data) throws Exception {
        Dialect dialect = ICodeStore.dialectFromResourceName(sourceName);
        return ICodeStore.parse(dialect, sourceName, data);
    }

    public static DeclarationList parse(Dialect dialect, String sourceName, InputStream data) throws Exception {
        AbstractParser parser = ICodeStore.parserForDialect(dialect, sourceName, data);
        return parser.parse_declaration_list();
    }

    public static AbstractParser parserForDialect(Dialect dialect, String path, InputStream data) throws IOException {
        switch (dialect) {
            case E: {
                return new ECleverParser(path, data);
            }
            case O: {
                return new OCleverParser(path, data);
            }
            case M: {
                return new MCleverParser(path, data);
            }
        }
        throw new RuntimeException("Unsupported extension: " + path);
    }

    public static Dialect dialectFromResourceName(String path) {
        int startExtension = path.lastIndexOf(".");
        String extension = path.substring(startExtension + 1).toLowerCase();
        if (!CODE_EXTENSIONS.contains(extension)) {
            return null;
        }
        String s = "" + extension.charAt(1);
        return Dialect.valueOf(s.toUpperCase());
    }

    public ModuleType getModuleType();

    public Dialect getModuleDialect();

    public String getModuleName();

    public PromptoVersion getModuleVersion();

    public void storeDeclarations(Iterable<IDeclaration> var1, Dialect var2, PromptoVersion var3, Object var4) throws PromptoError;

    default public Iterable<IDeclaration> fetchLatestDeclarations(String name) throws PromptoError {
        return this.fetchSpecificDeclarations(name, PromptoVersion.LATEST);
    }

    public Iterable<IDeclaration> fetchSpecificDeclarations(String var1, PromptoVersion var2) throws PromptoError;

    default public IDeclaration fetchLatestSymbol(String name) throws PromptoError {
        return this.fetchSpecificSymbol(name, PromptoVersion.LATEST);
    }

    public IDeclaration fetchSpecificSymbol(String var1, PromptoVersion var2) throws PromptoError;

    default public Batch fetchBatch(String name, PromptoVersion version) throws PromptoError {
        return (Batch)this.fetchModule(ModuleType.BATCH, name, version);
    }

    default public WebSite fetchApplication(String name, PromptoVersion version) throws PromptoError {
        return (WebSite)this.fetchModule(ModuleType.WEBSITE, name, version);
    }

    default public Script fetchScript(String name, PromptoVersion version) throws PromptoError {
        return (Script)this.fetchModule(ModuleType.SCRIPT, name, version);
    }

    default public Service fetchService(String name, PromptoVersion version) throws PromptoError {
        return (Service)this.fetchModule(ModuleType.SERVICE, name, version);
    }

    default public Library fetchLibrary(String name, PromptoVersion version) throws PromptoError {
        return (Library)this.fetchModule(ModuleType.LIBRARY, name, version);
    }

    default public Script fetchThesaurus(PromptoVersion version) throws PromptoError {
        return (Script)this.fetchModule(ModuleType.THESAURUS, ModuleType.THESAURUS.name(), version);
    }

    public Iterable<Module> fetchAllModules() throws PromptoError;

    public <T extends Module> T fetchModule(ModuleType var1, String var2, PromptoVersion var3) throws PromptoError;

    public Object fetchModuleDbId(String var1, PromptoVersion var2) throws PromptoError;

    public void storeModule(Module var1) throws PromptoError;

    public void dropModule(Module var1);

    public void storeDependency(Dependency var1);

    public void setMainModule(String var1, PromptoVersion var2);

    public void collectStorableAttributes(Map<String, AttributeDeclaration> var1) throws PromptoError;

    public ISection findSection(ISection var1);

    public Collection<String> fetchDeclarationNames();

    public void storeResource(Resource var1, Object var2);

    default public Resource fetchLatestResource(String path) throws PromptoError {
        return this.fetchSpecificResource(path, PromptoVersion.LATEST);
    }

    public Resource fetchSpecificResource(String var1, PromptoVersion var2);

    default public AttributeInfo fetchAttributeInfo(Context context, String name) {
        if ("category".equals(name)) {
            return AttributeInfo.CATEGORY;
        }
        Iterable<IDeclaration> decls = this.fetchLatestDeclarations(name);
        if (decls == null) {
            return null;
        }
        return StreamSupport.stream(decls.spliterator(), false).filter(d -> d instanceof AttributeDeclaration).map(d -> (AttributeDeclaration)d).map(d -> d.getAttributeInfo(context)).findFirst().orElse(null);
    }
}

