/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import prompto.code.Dependency;
import prompto.code.IApplication;
import prompto.code.ModuleStatus;
import prompto.code.ModuleType;
import prompto.error.PromptoError;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoStorableBase;
import prompto.intrinsic.PromptoVersion;
import prompto.runtime.Context;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;

public abstract class Module
extends PromptoStorableBase {
    private String name;
    private PromptoVersion version;
    private String description;
    private PromptoBinary image;
    private List<Dependency> dependencies;
    private ModuleStatus moduleStatus;
    private Boolean parked;

    public abstract ModuleType getType();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PromptoVersion getVersion() {
        return this.version;
    }

    public void setVersion(PromptoVersion version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PromptoBinary getImage() {
        return this.image;
    }

    public void setImage(PromptoBinary image) {
        this.image = image;
    }

    public IStorable collectStorables(Context context, IStore store, List<IStorable> storables) throws PromptoError {
        IStorable storable = store.newStorable(this.getCategories(), this.getDbIdFactory());
        storables.add(storable);
        storable.setData("name", this.name);
        storable.setData("version", this.version);
        if (this.description != null) {
            storable.setData("description", this.description);
        }
        if (this.image != null) {
            storable.setData("image", this.image);
        }
        if (this.dependencies != null) {
            List dbIds = this.dependencies.stream().map(d -> d.collectStorables(context, store, storables).getOrCreateDbId()).collect(Collectors.toList());
            storable.setData("dependencies", dbIds);
        }
        if (this.moduleStatus != null) {
            storable.setData("moduleStatus", this.moduleStatus.name());
        } else {
            storable.setData("moduleStatus", ModuleStatus.ACTIVE.name());
        }
        if (this.parked != null) {
            storable.setData("parked", this.parked);
        }
        return storable;
    }

    public void fromStored(IStore store, IStored stored) {
        this.setDbId(stored.getDbId());
        this.setName((String)stored.getData("name"));
        this.setVersion((PromptoVersion)stored.getData("version"));
        this.setDescription((String)stored.getData("description"));
        this.setImage((PromptoBinary)stored.getData("image"));
        List<Dependency> dependencies = Dependency.listFromStored(store, stored.getData("dependencies"));
        this.setDependencies(dependencies);
        String value = (String)stored.getData("moduleStatus");
        if (value != null) {
            this.setModuleStatus(ModuleStatus.valueOf(value));
        }
        this.setParked((Boolean)stored.getData("parked"));
    }

    private List<String> getCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        Class<?> klass = this.getClass();
        while (Module.class.isAssignableFrom(klass)) {
            categories.add(klass.getSimpleName());
            if (IApplication.class.isAssignableFrom(klass)) {
                categories.add("Application");
            }
            klass = klass.getSuperclass();
        }
        Collections.reverse(categories);
        return categories;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public boolean hasDependency(String name) {
        return this.dependencies == null ? false : this.dependencies.stream().anyMatch(d -> d.getName().equals(name));
    }

    public Dependency getDependency(String name) {
        return this.dependencies == null ? null : (Dependency)this.dependencies.stream().filter(d -> d.getName().equals(name)).findFirst().orElse(null);
    }

    public void setModuleStatus(ModuleStatus moduleStatus) {
        this.moduleStatus = moduleStatus;
    }

    public ModuleStatus getModuleStatus() {
        return this.moduleStatus;
    }

    public void setParked(Boolean parked) {
        this.parked = parked;
    }

    public Boolean getParked() {
        return this.parked;
    }
}

