/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import prompto.intrinsic.PromptoVersion;
import prompto.store.IStorable;
import prompto.store.IStore;

public abstract class Resource {
    private Object dbId;
    private String name;
    private PromptoVersion version;
    private String mimeType;
    private OffsetDateTime lastModified;

    public Object getDbId() {
        return this.dbId;
    }

    public void setDbId(Object dbId) {
        this.dbId = dbId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PromptoVersion getVersion() {
        return this.version;
    }

    public void setVersion(PromptoVersion version) {
        this.version = version;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public IStorable toStorable(IStore store) {
        IStorable storable = store.newStorable(this.getCategoryList(), null);
        this.setDbId(storable.getOrCreateDbId());
        storable.setData("name", this.getName());
        storable.setData("mimeType", this.getMimeType());
        storable.setData("version", this.getVersion());
        if (this.getLastModified() == null) {
            this.setLastModified(OffsetDateTime.now(ZoneOffset.UTC));
        }
        storable.setData("lastModified", this.getLastModified().toInstant().toEpochMilli());
        return storable;
    }

    protected abstract List<String> getCategoryList();

    public abstract long length();

    public abstract InputStream getInputStream() throws IOException;
}

