/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.util.ArrayList;
import java.util.List;
import prompto.compiler.BootstrapMethod;
import prompto.compiler.ByteWriter;
import prompto.compiler.ConstantsPool;
import prompto.compiler.IAttribute;
import prompto.compiler.Utf8Constant;

public class BootstrapMethodsAttribute
implements IAttribute {
    Utf8Constant attributeName = new Utf8Constant("BootstrapMethods");
    List<BootstrapMethod> methods = new ArrayList<BootstrapMethod>();

    public void addBootstrapMethod(BootstrapMethod method) {
        int idx = this.methods.indexOf(method);
        if (idx >= 0) {
            method.setIndexInBootstrapList(idx);
        } else {
            method.setIndexInBootstrapList(0);
            this.methods.add(method);
        }
    }

    @Override
    public void register(ConstantsPool pool) {
        this.attributeName.register(pool);
        this.methods.forEach(m -> m.register(pool));
    }

    @Override
    public int lengthWithoutHeader() {
        int length = 2;
        for (BootstrapMethod m : this.methods) {
            length += m.length();
        }
        return length;
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU2(this.attributeName.getIndexInConstantPool());
        writer.writeU4(this.lengthWithoutHeader());
        writer.writeU2(this.methods.size());
        this.methods.forEach(m -> m.writeTo(writer));
    }
}

