/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.io.IOException;
import java.io.OutputStream;
import prompto.compiler.CompilerException;

class ByteWriter {
    OutputStream o;
    int length = 0;

    ByteWriter(OutputStream o) {
        this.o = o;
    }

    public int length() {
        return this.length;
    }

    private void write(int i) {
        try {
            this.o.write(i);
            ++this.length;
        }
        catch (IOException e) {
            throw new CompilerException(e);
        }
    }

    void writeBytes(byte[] b) {
        try {
            this.o.write(b);
            this.length += b.length;
        }
        catch (IOException e) {
            throw new CompilerException(e);
        }
    }

    void writeU1(int u1) {
        this.write(u1);
    }

    void writeU2(int u2) {
        this.write(u2 >> 8);
        this.write(u2);
    }

    void writeU4(int u4) {
        this.write(u4 >> 24);
        this.write(u4 >> 16);
        this.write(u4 >> 8);
        this.write(u4);
    }
}

