/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import prompto.compiler.BootstrapMethod;
import prompto.compiler.ByteWriter;
import prompto.compiler.ConstantsPool;
import prompto.compiler.ICodeConstant;
import prompto.compiler.NameAndTypeConstant;
import prompto.compiler.StackEntry;

public class CallSiteConstant
implements ICodeConstant {
    int index;
    BootstrapMethod bootstrapMethod;
    NameAndTypeConstant methodNameAndType;

    public CallSiteConstant(BootstrapMethod bootstrapMethod, NameAndTypeConstant methodNameAndType) {
        this.bootstrapMethod = bootstrapMethod;
        this.methodNameAndType = methodNameAndType;
    }

    @Override
    public int getTag() {
        return 18;
    }

    @Override
    public void register(ConstantsPool pool) {
        this.index = pool.registerConstant(this);
        this.methodNameAndType.register(pool);
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU1(18);
        writer.writeU2(this.bootstrapMethod.getIndexInBootstrapList());
        writer.writeU2(this.methodNameAndType.getIndexInConstantPool());
    }

    @Override
    public int getIndexInConstantPool() {
        if (this.index == -1) {
            throw new UnsupportedOperationException();
        }
        return this.index;
    }

    public short getArgumentsCount(boolean isStatic) {
        return this.methodNameAndType.getArgumentsCount(isStatic);
    }

    public StackEntry resultToStackEntry() {
        return this.methodNameAndType.resultToStackEntry();
    }
}

