/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import prompto.compiler.ByteWriter;
import prompto.compiler.CompilerUtils;
import prompto.compiler.ConstantsPool;
import prompto.compiler.ICodeConstant;
import prompto.compiler.IValueConstant;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.NamedType;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackEntry;
import prompto.compiler.Utf8Constant;

public class ClassConstant
implements ICodeConstant,
IValueConstant {
    Type type;
    Utf8Constant className;
    int index = -1;

    public ClassConstant(Type type) {
        this.type = type;
        this.className = new Utf8Constant(CompilerUtils.makeClassName(type));
    }

    @Override
    public int getTag() {
        return 7;
    }

    public ClassConstant clone() {
        return new ClassConstant(this.type);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public StackEntry toStackEntry() {
        return IVerifierEntry.VerifierType.ITEM_Object.newStackEntry(this);
    }

    public ClassConstant toArray() {
        String className = this.className.toString().replace('/', '.') + "[]";
        if (this.type instanceof Class) {
            try {
                Class<?> klass = Class.forName(className);
                return new ClassConstant(klass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ClassConstant(new NamedType(className));
    }

    public boolean isInterface() {
        return new ResultInfo(this.type, new ResultInfo.Flag[0]).isInterface();
    }

    public Utf8Constant getClassName() {
        return this.className;
    }

    public String getSimpleName() {
        String fullName = this.className.getValue();
        return fullName.substring(fullName.lastIndexOf(47) + 1);
    }

    public String toString() {
        return this.className.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof ClassConstant && this.className.equals(((ClassConstant)obj).className);
    }

    @Override
    public int getIndexInConstantPool() {
        if (this.index == -1) {
            throw new UnsupportedOperationException();
        }
        return this.index;
    }

    @Override
    public void register(ConstantsPool pool) {
        this.index = pool.registerConstant(this);
        this.className.register(pool);
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU1(7);
        writer.writeU2(this.className.getIndexInConstantPool());
    }
}

