/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import prompto.compiler.BootstrapMethod;
import prompto.compiler.BootstrapMethodsAttribute;
import prompto.compiler.ByteWriter;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerException;
import prompto.compiler.ConstantsPool;
import prompto.compiler.Descriptor;
import prompto.compiler.FieldInfo;
import prompto.compiler.IAttribute;
import prompto.compiler.InnerClassInfo;
import prompto.compiler.InnerClassesAttribute;
import prompto.compiler.MethodInfo;

public class ClassFile {
    ConstantsPool constantsPool;
    ClassConstant thisClass;
    ClassConstant superClass;
    List<ClassConstant> interfaces = new ArrayList<ClassConstant>();
    List<FieldInfo> fields = new ArrayList<FieldInfo>();
    List<MethodInfo> methods = new ArrayList<MethodInfo>();
    List<IAttribute> attributes = new ArrayList<IAttribute>();
    InnerClassesAttribute innerClasses = null;
    BootstrapMethodsAttribute bootstrapMethods = null;
    int accessFlags = 33;

    public ClassFile(Type thisClassName) {
        this.thisClass = new ClassConstant(thisClassName);
    }

    public ConstantsPool getConstantsPool() {
        return this.constantsPool;
    }

    public ClassConstant getThisClass() {
        return this.thisClass;
    }

    public ClassConstant getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(ClassConstant superClass) {
        this.superClass = superClass;
    }

    public int getModifiers() {
        return this.accessFlags;
    }

    public void addModifier(int modifier) {
        if ((modifier & 0x200) != 0) {
            this.accessFlags &= 0xFFFFFFDF;
        }
        this.accessFlags |= modifier;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public void addInterface(Type type) {
        this.addInterface(new ClassConstant(type));
    }

    public void addInterface(ClassConstant interFace) {
        this.interfaces.add(interFace);
    }

    public void addField(FieldInfo field) {
        this.fields.add(field);
    }

    public MethodInfo newMethod(String name, Descriptor.Method descriptor) {
        MethodInfo method = new MethodInfo(this, name, descriptor);
        this.methods.add(method);
        return method;
    }

    public List<MethodInfo> getMethods() {
        return this.methods;
    }

    public boolean hasMethod(String methodName) {
        for (MethodInfo m : this.methods) {
            if (!methodName.equals(m.getName().getValue())) continue;
            return true;
        }
        return false;
    }

    public FieldInfo getFieldInfo(String fieldName) {
        return this.fields.stream().filter(f -> f.getName().toString().equals(fieldName)).findFirst().orElse(null);
    }

    public void setEnclosingMethod(MethodInfo method) {
        System.err.println("TODO: setEnclosingMethod");
    }

    public void addAttribute(IAttribute attribute) {
        this.attributes.add(attribute);
    }

    public void addInnerClass(ClassFile classFile) {
        InnerClassInfo info = new InnerClassInfo(classFile, this.getThisClass());
        this.addInnerClass(info);
    }

    public void addInnerClass(InnerClassInfo info) {
        if (this.innerClasses == null) {
            this.innerClasses = new InnerClassesAttribute();
            this.attributes.add(this.innerClasses);
        }
        this.innerClasses.addInnerClass(info);
    }

    public void addBootstrapMethod(BootstrapMethod method) {
        if (this.bootstrapMethods == null) {
            this.bootstrapMethods = new BootstrapMethodsAttribute();
            this.attributes.add(this.bootstrapMethods);
        }
        this.bootstrapMethods.addBootstrapMethod(method);
    }

    public Collection<ClassFile> getInnerClasses() {
        ArrayList<ClassFile> list = new ArrayList<ClassFile>();
        if (this.innerClasses != null) {
            this.innerClasses.getClasses().forEach(ici -> list.add(ici.getClassFile()));
        }
        return list;
    }

    public void writeTo(OutputStream o) throws CompilerException {
        this.constantsPool = this.registerConstants();
        ByteWriter writer = new ByteWriter(o);
        this.writeTo(writer);
    }

    private ConstantsPool registerConstants() {
        ConstantsPool pool = new ConstantsPool();
        this.thisClass.register(pool);
        if (this.superClass == null) {
            this.superClass = new ClassConstant((Type)((Object)Object.class));
        }
        this.superClass.register(pool);
        this.interfaces.forEach(s -> s.register(pool));
        this.fields.forEach(f -> f.register(pool));
        this.methods.forEach(m -> m.register(pool));
        this.attributes.forEach(a -> a.register(pool));
        return pool;
    }

    private void writeTo(ByteWriter writer) throws CompilerException {
        writer.writeU4(-889275714);
        writer.writeU2(0);
        writer.writeU2(52);
        this.constantsPool.write(writer);
        writer.writeU2(this.accessFlags);
        writer.writeU2(this.thisClass.getIndexInConstantPool());
        writer.writeU2(this.superClass.getIndexInConstantPool());
        writer.writeU2(this.interfaces.size());
        this.interfaces.forEach(i -> writer.writeU2(i.getIndexInConstantPool()));
        writer.writeU2(this.fields.size());
        this.fields.forEach(f -> f.writeTo(writer));
        writer.writeU2(this.methods.size());
        this.methods.forEach(m -> m.writeTo(writer));
        writer.writeU2(this.attributes.size());
        this.attributes.forEach(a -> a.writeTo(writer));
    }
}

