/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import prompto.compiler.ByteWriter;
import prompto.compiler.ConstantsPool;
import prompto.compiler.DumpLevel;
import prompto.compiler.ExceptionHandler;
import prompto.compiler.IAttribute;
import prompto.compiler.IInstruction;
import prompto.compiler.IInstructionListener;
import prompto.compiler.LocalVariableTableAttribute;
import prompto.compiler.StackLabel;
import prompto.compiler.StackLocal;
import prompto.compiler.StackMapTableAttribute;
import prompto.compiler.StackState;
import prompto.compiler.Utf8Constant;

public class CodeAttribute
implements IAttribute {
    Utf8Constant attributeName = new Utf8Constant("Code");
    List<IInstruction> instructions = new LinkedList<IInstruction>();
    List<ExceptionHandler> handlers = new LinkedList<ExceptionHandler>();
    List<IAttribute> attributes = new ArrayList<IAttribute>();
    LocalVariableTableAttribute locals = new LocalVariableTableAttribute();
    StackMapTableAttribute stackMapTable = new StackMapTableAttribute();
    List<IInstructionListener> listeners;
    byte[] opcodes;

    public CodeAttribute() {
        this.attributes.add(this.stackMapTable);
        this.listeners = new ArrayList<IInstructionListener>();
        this.opcodes = null;
    }

    public LocalVariableTableAttribute getLocals() {
        return this.locals;
    }

    public StackMapTableAttribute getStackMapTable() {
        return this.stackMapTable;
    }

    public StackState captureStackState() {
        CaptureStackState capture = new CaptureStackState();
        this.instructions.add(capture);
        return capture.getState();
    }

    public <T extends IInstructionListener> T addOffsetListener(T listener) {
        this.listeners.add(listener);
        return listener;
    }

    public IInstruction activateOffsetListener(IInstructionListener listener) {
        ListenerActivator activator = new ListenerActivator(listener::activate);
        this.instructions.add(activator);
        return activator;
    }

    public IInstruction inhibitOffsetListener(IInstructionListener listener) {
        ListenerActivator activator = new ListenerActivator(listener::inhibit);
        this.instructions.add(activator);
        return activator;
    }

    public void restoreFullStackState(StackState state) {
        RestoreStackState restore = new RestoreStackState(state, true, true);
        this.instructions.add(restore);
    }

    public void restoreStackEntries(StackState state) {
        RestoreStackState restore = new RestoreStackState(state, true, false);
        this.instructions.add(restore);
    }

    public void restoreStackLocals(StackState state) {
        RestoreStackState restore = new RestoreStackState(state, false, true);
        this.instructions.add(restore);
    }

    public StackLabel placeLabel(StackState state) {
        StackLabel.FULL label = new StackLabel.FULL(state);
        this.instructions.add(new PlaceLabelInstruction(label));
        return label;
    }

    public ExceptionHandler registerExceptionHandler(Type type) {
        ExceptionHandler handler = new ExceptionHandler(type);
        handler.setStackState(this.captureStackState());
        this.handlers.add(handler);
        this.listeners.add(handler);
        return handler;
    }

    public StackLabel placeExceptionHandler(ExceptionHandler handler) {
        StackState state = handler.getStackState();
        StackLabel.FULL label = new StackLabel.FULL(state);
        this.instructions.add(new PlaceLabelInstruction(label));
        handler.setLabel(label);
        this.restoreFullStackState(state);
        return label;
    }

    public String nextTransientName(String core) {
        return this.locals.nextTransientName(core);
    }

    public StackLocal registerLocal(StackLocal local) {
        StackLocal other = this.locals.registerLocal(local);
        if (other == local) {
            this.instructions.add(new PushLocalInstruction(local));
        }
        return other;
    }

    public void unregisterLocal(StackLocal local) {
        this.locals.unregisterLocal(local);
        this.instructions.add(new PopLocalInstruction(local));
    }

    public StackLocal getRegisteredLocal(String name) {
        return this.locals.getRegisteredLocal(name);
    }

    @Override
    public void register(ConstantsPool pool) {
        this.instructions.forEach(i -> {
            this.listeners.forEach(l -> l.onBeforeRehearse((IInstruction)i));
            i.rehearse(this);
            this.listeners.forEach(l -> l.onAfterRehearse((IInstruction)i));
        });
        this.instructions.forEach(i -> {
            this.listeners.forEach(l -> l.onBeforeRegister((IInstruction)i));
            i.register(pool);
            this.listeners.forEach(l -> l.onAfterRegister((IInstruction)i));
        });
        this.attributeName.register(pool);
        this.handlers.forEach(h -> h.register(pool));
        this.attributes.forEach(a -> a.register(pool));
    }

    public <T extends IInstruction> T addInstruction(T instruction) {
        this.instructions.add(instruction);
        return instruction;
    }

    byte[] createOpcodes() {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        ByteWriter w = new ByteWriter(o);
        this.instructions.forEach(i -> {
            this.listeners.forEach(l -> l.onBeforeWriteTo(w, (IInstruction)i));
            i.writeTo(w);
            this.listeners.forEach(l -> l.onAfterWriteTo(w, (IInstruction)i));
        });
        return o.toByteArray();
    }

    private int attributesLength() {
        return this.attributes.stream().flatMapToInt(a -> IntStream.of(a.lengthWithHeader())).sum();
    }

    private int handlersLength() {
        return this.handlers.size() * 8;
    }

    @Override
    public int lengthWithoutHeader() {
        if (this.opcodes == null) {
            this.opcodes = this.createOpcodes();
        }
        return 8 + this.opcodes.length + 2 + this.handlersLength() + 2 + this.attributesLength();
    }

    public byte[] getOpcodes() {
        return this.opcodes;
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU2(this.attributeName.getIndexInConstantPool());
        writer.writeU4(this.lengthWithoutHeader());
        writer.writeU2(this.stackMapTable.getMaxStack());
        writer.writeU2(this.stackMapTable.getMaxLocals());
        writer.writeU4(this.opcodes.length);
        writer.writeBytes(this.opcodes);
        writer.writeU2((short)this.handlers.size());
        this.handlers.forEach(h -> h.writeTo(writer));
        writer.writeU2((short)this.attributes.size());
        this.attributes.forEach(a -> a.writeTo(writer));
    }

    static class PopLocalInstruction
    implements IInstruction {
        StackLocal local;

        public PopLocalInstruction(StackLocal local) {
            this.local = local;
        }

        @Override
        public void rehearse(CodeAttribute code) {
            code.getStackMapTable().popLocal(this.local);
        }
    }

    static class PushLocalInstruction
    implements IInstruction {
        StackLocal local;

        public PushLocalInstruction(StackLocal local) {
            this.local = local;
        }

        @Override
        public void rehearse(CodeAttribute code) {
            code.getStackMapTable().pushLocal(this.local);
        }
    }

    static class PlaceLabelInstruction
    implements IInstruction {
        StackLabel label;

        public PlaceLabelInstruction(StackLabel label) {
            this.label = label;
        }

        @Override
        public void rehearse(CodeAttribute code) {
            code.getStackMapTable().addLabel(this.label);
        }

        @Override
        public void register(ConstantsPool pool) {
            this.label.register(pool);
        }

        @Override
        public void writeTo(ByteWriter writer) {
            this.label.setRealOffset(writer.length());
        }
    }

    static class RestoreStackState
    implements IInstruction {
        StackState state;
        boolean entries;
        boolean locals;

        public RestoreStackState(StackState state, boolean entries, boolean locals) {
            this.state = state;
            this.entries = entries;
            this.locals = locals;
        }

        public StackState getState() {
            return this.state;
        }

        @Override
        public void rehearse(CodeAttribute code) {
            code.getStackMapTable().getState().capture(this.state, this.entries, this.locals);
            if (DumpLevel.current().ordinal() > 0) {
                System.err.println("Restore stack: " + this.state.toString());
                System.err.println();
            }
        }
    }

    static class ListenerActivator
    implements IInstruction {
        Consumer<IInstructionListener.Phase> method;

        public ListenerActivator(Consumer<IInstructionListener.Phase> method) {
            this.method = method;
        }

        @Override
        public void rehearse(CodeAttribute code) {
            this.method.accept(IInstructionListener.Phase.REHEARSE);
        }

        @Override
        public void register(ConstantsPool pool) {
            this.method.accept(IInstructionListener.Phase.REGISTER);
        }

        @Override
        public void writeTo(ByteWriter writer) {
            this.method.accept(IInstructionListener.Phase.WRITE);
        }
    }

    static class CaptureStackState
    implements IInstruction {
        StackState state = new StackState();

        CaptureStackState() {
        }

        public StackState getState() {
            return this.state;
        }

        @Override
        public void rehearse(CodeAttribute code) {
            this.state.capture(code.getStackMapTable().getState(), true, true);
            if (DumpLevel.current().ordinal() > 0) {
                System.err.println("Capture stack: " + this.state.toString());
                System.err.println();
            }
        }

        @Override
        public void register(ConstantsPool pool) {
            this.state.register(pool);
        }
    }
}

