/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import prompto.compiler.ByteOperand;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerException;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.DumpLevel;
import prompto.compiler.FieldConstant;
import prompto.compiler.FieldInfo;
import prompto.compiler.IInstructionListener;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.IntConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NamedType;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.PromptoClassLoader;
import prompto.compiler.StackLocal;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.declaration.AbstractMethodDeclaration;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.EnumeratedCategoryDeclaration;
import prompto.declaration.EnumeratedNativeDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.TestMethodDeclaration;
import prompto.grammar.Identifier;
import prompto.grammar.ParameterList;
import prompto.intrinsic.PromptoCallSite;
import prompto.param.IParameter;
import prompto.runtime.Context;
import prompto.type.IType;
import prompto.utils.IOUtils;
import prompto.verifier.ClassVerifier;

public class Compiler {
    File classDir;

    Compiler(File classDir) throws Exception {
        this.classDir = classDir;
        String clean = System.getProperty("prompto.compiler.clean");
        if ("true".equals(clean)) {
            IOUtils.deleteFilesRecursively(classDir, false);
        }
    }

    public void compileClass(Context context, String fullName) throws ClassNotFoundException {
        ClassFile classFile = this.createClassFile(context, fullName);
        this.writeClassFile(classFile);
    }

    private ClassFile createClassFile(Context context, String fullName) throws ClassNotFoundException {
        if (fullName.startsWith("\u03c0.\u03b1.")) {
            return this.createAttributeClassFile(context, fullName);
        }
        if (fullName.startsWith("\u03c0.\u00b5.")) {
            return this.createGlobalMethodsClassFile(context, fullName);
        }
        if (fullName.startsWith("\u03c0.\u03c7.")) {
            return this.createCategoryClassFile(context, fullName);
        }
        if (fullName.startsWith("\u03c0.\u03b5.")) {
            return this.createEnumeratedCategoryClassFile(context, fullName);
        }
        if (fullName.startsWith("\u03c0.\u03b7.")) {
            return this.createEnumeratedNativeClassFile(context, fullName);
        }
        if (fullName.startsWith("\u03c0.\u03c4.")) {
            return this.createTestClassFile(context, fullName);
        }
        throw new ClassNotFoundException(fullName);
    }

    private ClassFile createAttributeClassFile(Context context, String fullName) throws ClassNotFoundException {
        String simpleName = CompilerUtils.attributeSimpleNameFrom(fullName);
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, new Identifier(simpleName));
        if (decl == null) {
            throw new ClassNotFoundException(simpleName);
        }
        return decl.compile(context, fullName);
    }

    private ClassFile createTestClassFile(Context context, String fullName) throws ClassNotFoundException {
        String simpleName = CompilerUtils.testSimpleNameFrom(fullName);
        TestMethodDeclaration decl = context.getTest(new Identifier(simpleName), true);
        if (decl == null) {
            throw new ClassNotFoundException(simpleName);
        }
        return decl.compile(context, fullName);
    }

    private ClassFile createEnumeratedNativeClassFile(Context context, String fullName) throws ClassNotFoundException {
        String simpleName = CompilerUtils.nativeEnumSimpleNameFrom(fullName);
        EnumeratedNativeDeclaration decl = context.getRegisteredDeclaration(EnumeratedNativeDeclaration.class, new Identifier(simpleName));
        if (decl == null) {
            throw new ClassNotFoundException(simpleName);
        }
        return decl.compile(context, fullName);
    }

    private ClassFile createEnumeratedCategoryClassFile(Context context, String fullName) throws ClassNotFoundException {
        String simpleName = CompilerUtils.categoryEnumSimpleNameFrom(fullName);
        EnumeratedCategoryDeclaration decl = context.getRegisteredDeclaration(EnumeratedCategoryDeclaration.class, new Identifier(simpleName));
        if (decl == null) {
            throw new ClassNotFoundException(simpleName);
        }
        return decl.compile(context, fullName);
    }

    private ClassFile createCategoryClassFile(Context context, String fullName) throws ClassNotFoundException {
        String simpleName = CompilerUtils.categorySimpleNameFrom(fullName);
        if (simpleName.indexOf(37) >= 0) {
            return this.createExtendedClassFile(context, simpleName, fullName);
        }
        return this.createRegularClassFile(context, simpleName, fullName);
    }

    private ClassFile createExtendedClassFile(Context context, String simpleName, String fullName) throws ClassNotFoundException {
        String[] interfaces;
        ClassFile classFile = new ClassFile(new NamedType(fullName));
        classFile.addModifier(1536);
        for (String s : interfaces = simpleName.split("%")) {
            if ("any".equals(s)) continue;
            IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, new Identifier(s));
            if (decl instanceof CategoryDeclaration) {
                classFile.addInterface(new ClassConstant(CompilerUtils.getCategoryInterfaceType(s)));
                continue;
            }
            if (decl instanceof AttributeDeclaration) {
                classFile.addInterface(new ClassConstant(CompilerUtils.getAttributeInterfaceType(s)));
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return classFile;
    }

    private ClassFile createRegularClassFile(Context context, String simpleName, String fullName) throws ClassNotFoundException {
        CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, new Identifier(simpleName));
        if (decl == null) {
            throw new ClassNotFoundException(simpleName);
        }
        return decl.compile(context, fullName);
    }

    private ClassFile createGlobalMethodsClassFile(Context context, String fullName) throws ClassNotFoundException {
        Context.MethodDeclarationMap methods;
        Type abstractType = CompilerUtils.abstractTypeFrom(fullName);
        String simpleName = fullName.substring(fullName.indexOf(".\u00b5.") + 3);
        int idx = simpleName.indexOf(36);
        if (idx > 0) {
            simpleName = simpleName.substring(0, idx);
        }
        if ((methods = context.getRegisteredDeclaration(Context.MethodDeclarationMap.class, new Identifier(simpleName), true)) == null) {
            throw new ClassNotFoundException(simpleName);
        }
        return this.createGlobalMethodsClassFile(context, methods, abstractType);
    }

    private ClassFile createGlobalMethodsClassFile(Context context, Context.MethodDeclarationMap methods, Type type) {
        Collection<IMethodDeclaration> decls = methods.globalConcreteMethods();
        if (decls.isEmpty()) {
            return this.createGlobalMethodsInterfaceFile(context, methods, type);
        }
        ClassFile classFile = new ClassFile(type);
        classFile.addModifier(1024);
        decls.forEach(m -> m.compile(context, true, classFile));
        if (decls.size() > 1) {
            this.createGlobalMethodHandles(classFile);
            this.populateGlobalMethodHandles(context, classFile, decls);
            this.createGlobalCheckParamsMethods(context, classFile, decls);
            this.createGlobalBootstrapMethod(classFile);
        }
        return classFile;
    }

    private ClassFile createGlobalMethodsInterfaceFile(Context context, Context.MethodDeclarationMap methods, Type type) {
        IMethodDeclaration method = (IMethodDeclaration)methods.values().iterator().next();
        if (method instanceof AbstractMethodDeclaration) {
            return ((AbstractMethodDeclaration)method).compileInterface(context, type);
        }
        throw new UnsupportedOperationException();
    }

    private void createGlobalMethodHandles(ClassFile classFile) {
        FieldInfo field = new FieldInfo("methodHandles", (Type)((Object)MethodHandle[].class));
        field.addModifier(8);
        classFile.addField(field);
    }

    private void populateGlobalMethodHandles(Context context, ClassFile classFile, Collection<IMethodDeclaration> decls) {
        Descriptor.Method proto = new Descriptor.Method(Void.TYPE);
        MethodInfo method = classFile.newMethod("<clinit>", proto);
        method.addModifier(8);
        method.addInstruction(Opcode.LDC, new IntConstant(decls.size()));
        method.addInstruction(Opcode.ANEWARRAY, new ClassConstant((Type)((Object)MethodHandle.class)));
        method.registerLocal("i", IVerifierEntry.VerifierType.ITEM_Integer, null);
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        method.addInstruction(Opcode.ISTORE_0, new IOperand[0]);
        for (IMethodDeclaration decl : decls) {
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            method.addInstruction(Opcode.ILOAD_0, new IOperand[0]);
            this.createGlobalMethodHandle(context, true, method, decl);
            method.addInstruction(Opcode.AASTORE, new IOperand[0]);
            method.addInstruction(Opcode.IINC, new ByteOperand(0), new ByteOperand(1));
        }
        FieldConstant fc = new FieldConstant(classFile.getThisClass(), "methodHandles", (Type)((Object)MethodHandle[].class));
        method.addInstruction(Opcode.PUTSTATIC, fc);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
    }

    private void createGlobalMethodHandle(Context context, boolean isStart, MethodInfo method, IMethodDeclaration decl) {
        MethodConstant mc = new MethodConstant((Type)((Object)MethodHandles.class), "lookup", new Type[]{MethodHandles.Lookup.class});
        method.addInstruction(Opcode.INVOKESTATIC, mc);
        method.addInstruction(Opcode.LDC, method.getClassFile().getThisClass());
        method.addInstruction(Opcode.LDC, new StringConstant(decl.getName()));
        IType returnType = decl.check(context, isStart);
        String descriptor = CompilerUtils.createMethodDescriptor(context, decl.getParameters(), returnType).toString();
        method.addInstruction(Opcode.LDC, new StringConstant(descriptor));
        mc = new MethodConstant((Type)((Object)PromptoClassLoader.class), "getInstance", new Type[]{PromptoClassLoader.class});
        method.addInstruction(Opcode.INVOKESTATIC, mc);
        mc = new MethodConstant((Type)((Object)MethodType.class), "fromMethodDescriptorString", new Type[]{String.class, ClassLoader.class, MethodType.class});
        method.addInstruction(Opcode.INVOKESTATIC, mc);
        mc = new MethodConstant((Type)((Object)MethodHandles.Lookup.class), "findStatic", new Type[]{Class.class, String.class, MethodType.class, MethodHandle.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, mc);
    }

    private void createGlobalBootstrapMethod(ClassFile classFile) {
        Descriptor.Method proto = new Descriptor.Method(new Type[]{MethodHandles.Lookup.class, String.class, MethodType.class, CallSite.class});
        MethodInfo method = classFile.newMethod("bootstrap", proto);
        method.addModifier(8);
        StackLocal lookup = method.registerLocal("lookup", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)MethodHandles.Lookup.class)));
        method.registerLocal("name", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)String.class)));
        StackLocal type = method.registerLocal("type", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)MethodType.class)));
        CompilerUtils.compileALOAD(method, lookup);
        method.addInstruction(Opcode.LDC, classFile.getThisClass());
        FieldConstant fc = new FieldConstant(classFile.getThisClass(), "methodHandles", (Type)((Object)MethodHandle[].class));
        method.addInstruction(Opcode.GETSTATIC, fc);
        CompilerUtils.compileALOAD(method, type);
        MethodConstant mc = new MethodConstant((Type)((Object)PromptoCallSite.class), "bootstrap", new Type[]{MethodHandles.Lookup.class, Class.class, MethodHandle[].class, MethodType.class, CallSite.class});
        method.addInstruction(Opcode.INVOKESTATIC, mc);
        method.addInstruction(Opcode.ARETURN, new IOperand[0]);
    }

    private void createGlobalCheckParamsMethods(Context context, ClassFile classFile, Collection<IMethodDeclaration> decls) {
        for (IMethodDeclaration decl : decls) {
            this.createGlobalCheckParamsMethod(context, classFile, decl.getParameters());
        }
    }

    private void createGlobalCheckParamsMethod(Context context, ClassFile classFile, ParameterList arguments) {
        String name = this.buildGlobalCheckParamsMethodName(context, arguments);
        Type[] types = this.buildGlobalCheckParamsMethodTypes(arguments.size());
        Descriptor.Method desc = new Descriptor.Method(types, (Type)Boolean.TYPE);
        MethodInfo method = classFile.newMethod(name, desc);
        method.addModifier(8);
        StackState state = method.captureStackState();
        ArrayList<OffsetListenerConstant> listeners = new ArrayList<OffsetListenerConstant>();
        for (int i = 0; i < arguments.size(); ++i) {
            method.registerLocal("p" + i, IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)Object.class)));
            method.addInstruction(Opcode.LDC, new ClassConstant(((IParameter)arguments.get(i)).getJavaType(context)));
            CompilerUtils.compileALOAD(method, "p" + i);
            MethodConstant mc = new MethodConstant((Type)((Object)Class.class), "isInstance", new Type[]{Object.class, Boolean.TYPE});
            method.addInstruction(Opcode.INVOKEVIRTUAL, mc);
            OffsetListenerConstant listener = method.addOffsetListener(new OffsetListenerConstant());
            listeners.add(listener);
            method.activateOffsetListener(listener);
            method.addInstruction(Opcode.IFEQ, listener);
        }
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        method.addInstruction(Opcode.IRETURN, new IOperand[0]);
        listeners.forEach(l -> method.inhibitOffsetListener((IInstructionListener)l));
        method.restoreFullStackState(state);
        method.placeLabel(state);
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        method.addInstruction(Opcode.IRETURN, new IOperand[0]);
    }

    private Type[] buildGlobalCheckParamsMethodTypes(int size) {
        Type[] types = new Type[size];
        while (size-- > 0) {
            types[size] = Object.class;
        }
        return types;
    }

    private String buildGlobalCheckParamsMethodName(Context context, ParameterList arguments) {
        StringBuilder sb = new StringBuilder();
        sb.append("checkParams");
        for (IParameter arg : arguments) {
            String typeName = arg.getJavaType(context).getTypeName();
            String name = typeName.substring(typeName.lastIndexOf(46) + 1);
            sb.append(name);
        }
        return sb.toString();
    }

    private void writeClassFile(ClassFile classFile) throws CompilerException {
        try {
            Type type = classFile.getThisClass().getType();
            String fullName = type.getTypeName().replace('.', '/');
            File parent = new File(this.classDir, fullName.substring(0, fullName.lastIndexOf(47) + 1));
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException("Could not create " + parent.getAbsolutePath());
            }
            File file = new File(parent, fullName.substring(fullName.lastIndexOf(47) + 1) + ".class");
            if (DumpLevel.current().ordinal() > 0) {
                System.err.println("Writing class file: " + file.getAbsolutePath());
            }
            try (FileOutputStream out = new FileOutputStream(file);){
                classFile.writeTo(out);
            }
            if ("true".equals(System.getProperty("prompto-verify-class"))) {
                ClassVerifier verifier = new ClassVerifier(classFile);
                verifier.verify();
            }
            for (ClassFile inner : classFile.getInnerClasses()) {
                this.writeClassFile(inner);
            }
        }
        catch (Exception e) {
            throw new CompilerException(e);
        }
    }
}

