/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import prompto.compiler.ByteOperand;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerException;
import prompto.compiler.Descriptor;
import prompto.compiler.FieldConstant;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.IntConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NamedType;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.compiler.StringConstant;
import prompto.grammar.Identifier;
import prompto.grammar.ParameterList;
import prompto.param.CodeParameter;
import prompto.runtime.Context;
import prompto.store.AttributeInfo;
import prompto.store.Family;
import prompto.type.IType;
import prompto.utils.IdentifierList;

public abstract class CompilerUtils {
    static Map<Type, String> descriptors = CompilerUtils.createDescriptorsMap();
    public static final String GLOBAL_METHOD_PACKAGE_PREFIX = "\u03c0.\u00b5.";
    public static final String TEST_METHOD_PACKAGE_PREFIX = "\u03c0.\u03c4.";
    public static final String ATTRIBUTE_PACKAGE_PREFIX = "\u03c0.\u03b1.";
    public static final String CATEGORY_PACKAGE_PREFIX = "\u03c0.\u03c7.";
    public static final String CATEGORY_ENUM_PACKAGE_PREFIX = "\u03c0.\u03b5.";
    public static final String NATIVE_ENUM_PACKAGE_PREFIX = "\u03c0.\u03b7.";
    public static final String INNER_SEPARATOR = "$%";
    static Map<Character, String> invalidCharMap = CompilerUtils.createInvalidCharMap();
    static Map<String, Character> entityCharMap = CompilerUtils.createEntityCharMap();

    static String[] parseDescriptor(String proto) {
        ArrayList<String> params = new ArrayList<String>();
        block5: while (proto.length() > 0) {
            switch (proto.charAt(0)) {
                case '(': 
                case '[': {
                    proto = proto.substring(1);
                    continue block5;
                }
                case ')': {
                    params.add(proto.substring(1));
                    return params.toArray(new String[params.size()]);
                }
                case 'L': {
                    int idx = proto.indexOf(59) + 1;
                    params.add(proto.substring(0, idx));
                    proto = proto.substring(idx);
                    continue block5;
                }
            }
            params.add(proto.substring(0, 1));
            proto = proto.substring(1);
        }
        throw new CompilerException(new UnexpectedException("Should never get there"));
    }

    private static Map<Type, String> createDescriptorsMap() {
        HashMap<Type, String> map = new HashMap<Type, String>();
        map.put(Byte.TYPE, "B");
        map.put(Character.TYPE, "C");
        map.put(Double.TYPE, "D");
        map.put(Float.TYPE, "F");
        map.put(Integer.TYPE, "I");
        map.put(Long.TYPE, "J");
        map.put(Short.TYPE, "S");
        map.put(Boolean.TYPE, "Z");
        map.put(Void.TYPE, "V");
        return map;
    }

    public static String getDescriptor(Type type) {
        if (type instanceof Class && ((Class)type).isArray()) {
            return "[" + CompilerUtils.getDescriptor(((Class)type).getComponentType());
        }
        String s = descriptors.get(type);
        return s != null ? s : "L" + CompilerUtils.makeClassName(type) + ';';
    }

    public static String getGenericDescriptor(Type genericType, List<Type> parameterTypes) {
        if (parameterTypes.isEmpty()) {
            return CompilerUtils.getDescriptor(genericType);
        }
        return "L" + CompilerUtils.makeClassName(genericType) + "<" + parameterTypes.stream().map(CompilerUtils::getDescriptor).collect(Collectors.joining()) + ">;";
    }

    public static String makeClassName(Type type) {
        return CompilerUtils.makeClassName(type.getTypeName());
    }

    public static String makeClassName(String name) {
        return name.replace('.', '/');
    }

    public static String createProto(Type ... types) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < types.length - 1; ++i) {
            sb.append(CompilerUtils.getDescriptor(types[i]));
        }
        sb.append(')');
        sb.append(CompilerUtils.getDescriptor(types[types.length - 1]));
        return sb.toString();
    }

    public static Descriptor.Method createMethodDescriptor(Context context, ParameterList parameters, IType returnType) {
        List<Type> paramTypes = parameters.stream().filter(a -> !(a instanceof CodeParameter)).map(arg -> arg.getJavaType(context)).collect(Collectors.toList());
        return new Descriptor.Method(paramTypes.toArray(new Type[paramTypes.size()]), returnType.getJavaType(context));
    }

    public static String createProto(Type[] parameterTypes, Type returnType) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Type type : parameterTypes) {
            sb.append(CompilerUtils.getDescriptor(type));
        }
        sb.append(')');
        sb.append(CompilerUtils.getDescriptor(returnType));
        return sb.toString();
    }

    public static Type getTestType(String testName) {
        testName = CompilerUtils.encodeName(testName);
        return new NamedType(TEST_METHOD_PACKAGE_PREFIX + testName);
    }

    private static Map<Character, String> createInvalidCharMap() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf('.'), "'46'");
        map.put(Character.valueOf(';'), "'59'");
        map.put(Character.valueOf('['), "'91'");
        map.put(Character.valueOf('/'), "'47'");
        map.put(Character.valueOf(':'), "'58'");
        map.put(Character.valueOf('\\'), "'92'");
        map.put(Character.valueOf('&'), "'38'");
        map.put(Character.valueOf('\''), "'39'");
        return map;
    }

    private static Map<String, Character> createEntityCharMap() {
        HashMap<String, Character> map = new HashMap<String, Character>();
        invalidCharMap.entrySet().forEach(e -> {
            Character cfr_ignored_0 = (Character)map.put((String)e.getValue(), (Character)e.getKey());
        });
        return map;
    }

    public static String decodeName(String name) {
        StringBuilder sb = new StringBuilder();
        while (name.length() > 0) {
            int idx = name.indexOf(39);
            if (idx < 0) {
                sb.append(name);
                return sb.toString();
            }
            if (idx > 0) {
                sb.append(name.substring(0, idx));
                name = name.substring(idx);
            }
            if (name.length() >= 4) {
                String key = name.substring(0, 4);
                if (!entityCharMap.containsKey(key)) continue;
                name = name.substring(4);
                sb.append(entityCharMap.get(key));
                continue;
            }
            sb.append(name);
            return sb.toString();
        }
        throw new UnsupportedOperationException("Should never get there!");
    }

    public static String encodeName(String name) {
        StringBuilder sb = new StringBuilder();
        for (char c : name.toCharArray()) {
            sb.append(CompilerUtils.encodeChar(Character.valueOf(c)));
        }
        return sb.toString();
    }

    private static String encodeChar(Character c) {
        String s = invalidCharMap.get(c);
        return s == null ? c.toString() : s;
    }

    public static Type getGlobalMethodType(Identifier id) {
        return CompilerUtils.getGlobalMethodType(id.toString());
    }

    public static Type getGlobalMethodType(String name) {
        return new NamedType(GLOBAL_METHOD_PACKAGE_PREFIX + name);
    }

    public static Type attributeInterfaceTypeFrom(String fullName) {
        return CompilerUtils.interfaceTypeFrom(fullName);
    }

    public static Type attributeConcreteTypeFrom(String fullName) {
        int idx = fullName.indexOf(36);
        if (idx < 0) {
            fullName = fullName + INNER_SEPARATOR + CompilerUtils.attributeSimpleNameFrom(fullName);
        }
        return new NamedType(fullName);
    }

    public static Type categoryConcreteTypeFrom(String fullName) {
        int idx = fullName.indexOf(36);
        if (idx < 0) {
            fullName = fullName + INNER_SEPARATOR + CompilerUtils.categorySimpleNameFrom(fullName);
        }
        return new NamedType(fullName);
    }

    public static Type categoryConcreteParentTypeFrom(String fullName) {
        if (fullName.indexOf(36) != fullName.lastIndexOf(36)) {
            fullName = fullName.substring(0, fullName.lastIndexOf(36));
        }
        return CompilerUtils.categoryConcreteTypeFrom(fullName);
    }

    public static Type abstractTypeFrom(String fullName) {
        return CompilerUtils.interfaceTypeFrom(fullName);
    }

    public static Type singletonTypeFrom(String fullName) {
        return CompilerUtils.interfaceTypeFrom(fullName);
    }

    public static Type categoryInterfaceTypeFrom(String fullName) {
        return CompilerUtils.interfaceTypeFrom(fullName);
    }

    private static Type interfaceTypeFrom(String fullName) {
        int idx = fullName.indexOf(INNER_SEPARATOR);
        if (idx >= 0) {
            fullName = fullName.substring(0, idx);
        }
        return new NamedType(fullName);
    }

    public static String categorySimpleNameFrom(String fullName) {
        String simpleName = fullName.substring(CATEGORY_PACKAGE_PREFIX.length());
        int idx = simpleName.indexOf(36);
        if (idx >= 0) {
            simpleName = simpleName.substring(0, idx);
        }
        return simpleName;
    }

    public static String categoryEnumSimpleNameFrom(String fullName) {
        String simpleName = fullName.substring(CATEGORY_ENUM_PACKAGE_PREFIX.length());
        int idx = simpleName.indexOf(36);
        if (idx >= 0) {
            simpleName = simpleName.substring(0, idx);
        }
        return simpleName;
    }

    public static String nativeEnumSimpleNameFrom(String fullName) {
        String simpleName = fullName.substring(NATIVE_ENUM_PACKAGE_PREFIX.length());
        int idx = simpleName.indexOf(36);
        if (idx >= 0) {
            simpleName = simpleName.substring(0, idx);
        }
        return simpleName;
    }

    public static String attributeSimpleNameFrom(String fullName) {
        return fullName.substring(ATTRIBUTE_PACKAGE_PREFIX.length());
    }

    public static String testSimpleNameFrom(String fullName) {
        String simpleName = fullName.substring(TEST_METHOD_PACKAGE_PREFIX.length());
        return CompilerUtils.decodeName(simpleName);
    }

    public static Type getAttributeInterfaceType(Identifier id) {
        return CompilerUtils.getAttributeInterfaceType(id.toString());
    }

    public static Type getAttributeInterfaceType(String name) {
        return new NamedType(ATTRIBUTE_PACKAGE_PREFIX + name);
    }

    public static Type getAttributeConcreteType(Identifier id) {
        return CompilerUtils.getAttributeConcreteType(id.toString());
    }

    public static Type getAttributeConcreteType(String name) {
        return new NamedType(ATTRIBUTE_PACKAGE_PREFIX + name + INNER_SEPARATOR + name);
    }

    public static Type getCategoryInterfaceType(Identifier id) {
        return CompilerUtils.getCategoryInterfaceType(id.toString());
    }

    public static Type getExtendedInterfaceType(Identifier id, IdentifierList attributes) {
        List<String> names = attributes.stream().map(name -> name.toString()).sorted().collect(Collectors.toList());
        return CompilerUtils.getExtendedInterfaceType(id.toString(), names);
    }

    public static Type getExtendedInterfaceType(String name, List<String> names) {
        StringBuilder sb = new StringBuilder();
        sb.append(CATEGORY_PACKAGE_PREFIX);
        sb.append(name);
        names.forEach(n -> {
            sb.append('%');
            sb.append((String)n);
        });
        return new NamedType(sb.toString());
    }

    public static Type getCategorySingletonType(Identifier id) {
        return CompilerUtils.getCategoryInterfaceType(id.toString());
    }

    public static Type getCategoryConcreteType(Identifier id) {
        return CompilerUtils.getCategoryConcreteType(id.toString());
    }

    public static Type getCategoryInterfaceType(String name) {
        return new NamedType(CATEGORY_PACKAGE_PREFIX + name);
    }

    public static Type getCategoryConcreteType(String name) {
        return new NamedType(CATEGORY_PACKAGE_PREFIX + name + INNER_SEPARATOR + name);
    }

    public static Type getCategoryEnumInterfaceType(Identifier id) {
        return CompilerUtils.getCategoryEnumInterfaceType(id.toString());
    }

    public static Type getCategoryEnumConcreteType(Identifier id) {
        return CompilerUtils.getCategoryEnumConcreteType(id.toString());
    }

    public static Type getExceptionType(Type type, String name) {
        return new NamedType(type.getTypeName() + '$' + name);
    }

    public static Type getNativeEnumType(Identifier id) {
        return CompilerUtils.getNativeEnumType(id.toString());
    }

    public static Type getNativeEnumType(String name) {
        return new NamedType(NATIVE_ENUM_PACKAGE_PREFIX + name);
    }

    public static Type getCategoryEnumInterfaceType(String name) {
        return new NamedType(CATEGORY_ENUM_PACKAGE_PREFIX + name);
    }

    public static Type getCategoryEnumConcreteType(String name) {
        return new NamedType(CATEGORY_ENUM_PACKAGE_PREFIX + name + INNER_SEPARATOR + name);
    }

    public static ResultInfo reverseBoolean(MethodInfo method) {
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        method.addInstruction(Opcode.ISUB, new IOperand[0]);
        return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo booleanToBoolean(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Boolean.class), "valueOf", new Type[]{Boolean.TYPE, Boolean.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)Boolean.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo booleanToBoolean(MethodInfo method, ResultInfo info) {
        if (Boolean.TYPE == info.getType()) {
            return CompilerUtils.booleanToBoolean(method);
        }
        if (Boolean.class == info.getType()) {
            return info;
        }
        throw new CompilerException("Cannot convert " + info.getType().getTypeName() + " to long");
    }

    public static ResultInfo BooleanToboolean(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Boolean.class), "booleanValue", Boolean.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo ByteToLong(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Byte.class), "longValue", new Type[]{Long.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return CompilerUtils.longToLong(method);
    }

    public static ResultInfo ShortToLong(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Short.class), "longValue", new Type[]{Long.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return CompilerUtils.longToLong(method);
    }

    public static ResultInfo intTolong(MethodInfo method) {
        method.addInstruction(Opcode.I2L, new IOperand[0]);
        return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo intToLong(MethodInfo method) {
        method.addInstruction(Opcode.I2L, new IOperand[0]);
        return CompilerUtils.longToLong(method);
    }

    public static ResultInfo longToint(MethodInfo method) {
        method.addInstruction(Opcode.L2I, new IOperand[0]);
        return new ResultInfo(Integer.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo IntegerToLong(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Integer.class), "longValue", Long.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return CompilerUtils.longToLong(method);
    }

    public static ResultInfo longToLong(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Long.class), "valueOf", new Type[]{Long.TYPE, Long.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)Long.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo longTodouble(MethodInfo method) {
        method.addInstruction(Opcode.L2D, new IOperand[0]);
        return new ResultInfo(Double.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo doubleTolong(MethodInfo method) {
        method.addInstruction(Opcode.D2L, new IOperand[0]);
        return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo floatToDouble(MethodInfo method) {
        method.addInstruction(Opcode.F2D, new IOperand[0]);
        return CompilerUtils.doubleToDouble(method);
    }

    public static ResultInfo FloatToDouble(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Float.class), "doubleValue", new Type[]{Double.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return CompilerUtils.doubleToDouble(method);
    }

    public static ResultInfo LongTodouble(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Long.class), "doubleValue", Double.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo(Double.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo LongTolong(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Long.class), "longValue", Long.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo LongToint(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Long.class), "intValue", Integer.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo(Integer.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo LongToDouble(MethodInfo method) {
        CompilerUtils.LongTodouble(method);
        return CompilerUtils.doubleToDouble(method);
    }

    public static ResultInfo DoubleTodouble(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Double.class), "doubleValue", Double.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo(Double.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo DoubleTolong(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Double.class), "longValue", Long.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo DoubleToLong(MethodInfo method) {
        CompilerUtils.DoubleTolong(method);
        return CompilerUtils.longToLong(method);
    }

    public static ResultInfo doubleToLong(MethodInfo method) {
        method.addInstruction(Opcode.D2L, new IOperand[0]);
        return CompilerUtils.longToLong(method);
    }

    public static ResultInfo longToDouble(MethodInfo method) {
        method.addInstruction(Opcode.L2D, new IOperand[0]);
        return CompilerUtils.doubleToDouble(method);
    }

    public static ResultInfo doubleToDouble(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Double.class), "valueOf", new Type[]{Double.TYPE, Double.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)Double.class), new ResultInfo.Flag[0]);
    }

    public static void numberToPrimitive(MethodInfo method, ResultInfo info, boolean toDecimal) {
        if (toDecimal) {
            CompilerUtils.numberTodouble(method, info);
        } else {
            CompilerUtils.numberTolong(method, info);
        }
    }

    public static ResultInfo numberTodouble(MethodInfo method, ResultInfo info) {
        if (Double.TYPE == info.getType()) {
            return info;
        }
        if (Long.TYPE == info.getType()) {
            return CompilerUtils.longTodouble(method);
        }
        if (Long.class == info.getType()) {
            return CompilerUtils.LongTodouble(method);
        }
        if (Double.class == info.getType()) {
            return CompilerUtils.DoubleTodouble(method);
        }
        throw new CompilerException("Cannot convert " + info.getType().getTypeName() + " to double");
    }

    public static ResultInfo numberToDouble(MethodInfo method, ResultInfo info) {
        if (Double.TYPE == info.getType()) {
            return CompilerUtils.doubleToDouble(method);
        }
        if (Long.TYPE == info.getType()) {
            return CompilerUtils.longToDouble(method);
        }
        if (Long.class == info.getType()) {
            return CompilerUtils.LongToDouble(method);
        }
        if (Double.class == info.getType()) {
            return info;
        }
        throw new CompilerException("Cannot convert " + info.getType().getTypeName() + " to double");
    }

    public static ResultInfo numberTolong(MethodInfo method, ResultInfo info) {
        if (Long.TYPE == info.getType()) {
            return info;
        }
        if (Double.TYPE == info.getType()) {
            return CompilerUtils.doubleTolong(method);
        }
        if (Long.class == info.getType()) {
            return CompilerUtils.LongTolong(method);
        }
        if (Double.class == info.getType()) {
            return CompilerUtils.DoubleTolong(method);
        }
        throw new CompilerException("Cannot convert " + info.getType().getTypeName() + " to long");
    }

    public static ResultInfo numberToLong(MethodInfo method, ResultInfo info) {
        if (Long.TYPE == info.getType()) {
            return CompilerUtils.longToLong(method);
        }
        if (Double.TYPE == info.getType()) {
            return CompilerUtils.doubleToLong(method);
        }
        if (Long.class == info.getType()) {
            return info;
        }
        if (Double.class == info.getType()) {
            return CompilerUtils.DoubleToLong(method);
        }
        throw new CompilerException("Cannot convert " + info.getType().getTypeName() + " to long");
    }

    public static ResultInfo numberToint(MethodInfo method, ResultInfo info) {
        CompilerUtils.numberTolong(method, info);
        return CompilerUtils.longToint(method);
    }

    public static ResultInfo charToCharacter(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Character.class), "valueOf", new Type[]{Character.TYPE, Character.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)Character.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo charToString(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Character.class), "toString", new Type[]{Character.TYPE, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo CharacterTochar(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Character.class), "charValue", Character.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo(Character.TYPE, new ResultInfo.Flag[0]);
    }

    public static ResultInfo CharacterToString(MethodInfo method) {
        MethodConstant oper = new MethodConstant((Type)((Object)Character.class), "toString", new Type[]{String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo compileNewRawInstance(MethodInfo method, Type klass) {
        ClassConstant c = new ClassConstant(klass);
        method.addInstruction(Opcode.NEW, c);
        return new ResultInfo(klass, new ResultInfo.Flag[0]);
    }

    public static ResultInfo compileCallConstructor(MethodInfo method, Type klass, Type ... params) {
        Descriptor.Method desc = new Descriptor.Method(params, (Type)Void.TYPE);
        MethodConstant c = new MethodConstant(klass, "<init>", desc);
        method.addInstruction(Opcode.INVOKESPECIAL, c);
        return new ResultInfo(klass, new ResultInfo.Flag[0]);
    }

    public static ResultInfo compileNewInstance(MethodInfo method, Type klass) {
        CompilerUtils.compileNewRawInstance(method, klass);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        return CompilerUtils.compileCallConstructor(method, klass, new Type[0]);
    }

    public static Type getType(Identifier identifier) {
        return CompilerUtils.getType(identifier.toString());
    }

    public static Type getType(String name) {
        name = name.replace('.', '/');
        return new NamedType(name);
    }

    public static String setterName(String name) {
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String getterName(String name) {
        return "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String checkerName(String name) {
        return "check" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static MethodInfo compileEmptyConstructor(ClassFile classFile) {
        Descriptor.Method proto = new Descriptor.Method(Void.TYPE);
        MethodInfo method = classFile.newMethod("<init>", proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_UninitializedThis, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
        MethodConstant m = new MethodConstant(classFile.getSuperClass(), "<init>", Void.TYPE);
        method.addInstruction(Opcode.INVOKESPECIAL, m);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
        return method;
    }

    public static MethodInfo compileSuperConstructor(ClassFile classFile, Type paramType) {
        Descriptor.Method proto = new Descriptor.Method(paramType, Void.TYPE);
        MethodInfo method = classFile.newMethod("<init>", proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_UninitializedThis, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_1, new ClassConstant(paramType));
        MethodConstant m = new MethodConstant(classFile.getSuperClass(), "<init>", paramType, Void.TYPE);
        method.addInstruction(Opcode.INVOKESPECIAL, m);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
        return method;
    }

    public static void compileJavaEnum(Context context, MethodInfo method, Flags flags, Enum<?> value) {
        method.addInstruction(Opcode.GETSTATIC, new FieldConstant(value.getClass(), value.name(), value.getClass()));
    }

    public static void compileAttributeInfo(Context context, MethodInfo method, Flags flags, AttributeInfo info) {
        CompilerUtils.compileNewRawInstance(method, AttributeInfo.class);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        method.addInstruction(Opcode.LDC, new StringConstant(info.getName()));
        CompilerUtils.compileJavaEnum(context, method, flags, info.getFamily());
        method.addInstruction(info.isCollection() ? Opcode.ICONST_1 : Opcode.ICONST_0, new IOperand[0]);
        method.addInstruction(info.isKey() ? Opcode.ICONST_1 : Opcode.ICONST_0, new IOperand[0]);
        method.addInstruction(info.isValue() ? Opcode.ICONST_1 : Opcode.ICONST_0, new IOperand[0]);
        method.addInstruction(info.isWords() ? Opcode.ICONST_1 : Opcode.ICONST_0, new IOperand[0]);
        CompilerUtils.compileCallConstructor(method, AttributeInfo.class, new Type[]{String.class, Family.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
    }

    public static ResultInfo compileALOAD(MethodInfo method, String localName) {
        StackLocal value = method.getRegisteredLocal(localName);
        return CompilerUtils.compileALOAD(method, value);
    }

    public static ResultInfo compileALOAD(MethodInfo method, StackLocal value) {
        ClassConstant klass;
        ClassConstant classConstant = klass = value instanceof StackLocal.ObjectLocal ? ((StackLocal.ObjectLocal)value).getClassName() : new ClassConstant((Type)((Object)Object.class));
        if (value.getIndex() < 4) {
            Opcode opcode = Opcode.values()[value.getIndex() + Opcode.ALOAD_0.ordinal()];
            method.addInstruction(opcode, klass);
        } else if (value.getIndex() < 255) {
            method.addInstruction(Opcode.ALOAD, new ByteOperand((byte)value.getIndex()), klass);
        } else {
            throw new UnsupportedOperationException();
        }
        return new ResultInfo(klass.getType(), new ResultInfo.Flag[0]);
    }

    public static void compileASTORE(MethodInfo method, StackLocal value) {
        ClassConstant klass;
        ClassConstant classConstant = klass = value instanceof StackLocal.ObjectLocal ? ((StackLocal.ObjectLocal)value).getClassName() : new ClassConstant((Type)((Object)Object.class));
        if (value.getIndex() < 4) {
            Opcode opcode = Opcode.values()[value.getIndex() + Opcode.ASTORE_0.ordinal()];
            method.addInstruction(opcode, klass);
        } else if (value.getIndex() < 255) {
            method.addInstruction(Opcode.ASTORE, new ByteOperand((byte)value.getIndex()), klass);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static ResultInfo compileILOAD(MethodInfo method, StackLocal value) {
        if (value.getIndex() < 4) {
            Opcode opcode = Opcode.values()[value.getIndex() + Opcode.ILOAD_0.ordinal()];
            method.addInstruction(opcode, new IOperand[0]);
        } else if (value.getIndex() < 255) {
            method.addInstruction(Opcode.ILOAD, new ByteOperand((byte)value.getIndex()));
        } else {
            throw new UnsupportedOperationException();
        }
        return new ResultInfo(Integer.TYPE, new ResultInfo.Flag[0]);
    }

    public static void compileISTORE(MethodInfo method, StackLocal value) {
        if (value.getIndex() < 4) {
            Opcode opcode = Opcode.values()[value.getIndex() + Opcode.ISTORE_0.ordinal()];
            method.addInstruction(opcode, new IOperand[0]);
        } else if (value.getIndex() < 255) {
            method.addInstruction(Opcode.ISTORE, new ByteOperand((byte)value.getIndex()));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void compileClassConstantsArray(MethodInfo method, List<Type> types) {
        if (types.size() <= 5) {
            Opcode opcode = Opcode.values()[Opcode.ICONST_0.ordinal() + types.size()];
            method.addInstruction(opcode, new IOperand[0]);
        } else {
            method.addInstruction(Opcode.LDC, new IntConstant(types.size()));
        }
        method.addInstruction(Opcode.ANEWARRAY, new ClassConstant((Type)((Object)Class.class)));
        IntStream.range(0, types.size()).forEach(i -> {
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            if (i <= 5) {
                Opcode opcode = Opcode.values()[Opcode.ICONST_0.ordinal() + i];
                method.addInstruction(opcode, new IOperand[0]);
            } else {
                method.addInstruction(Opcode.LDC, new IntConstant(i));
            }
            method.addInstruction(Opcode.LDC, new ClassConstant((Type)types.get(i)));
            method.addInstruction(Opcode.AASTORE, new IOperand[0]);
        });
    }

    public static boolean isEnumNativeType(Type type) {
        return type.getTypeName().startsWith(NATIVE_ENUM_PACKAGE_PREFIX);
    }
}

