/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.util.LinkedList;
import prompto.compiler.ByteWriter;
import prompto.compiler.CompilerException;
import prompto.compiler.IConstantOperand;

public class ConstantsPool
extends LinkedList<IConstantOperand> {
    int nextIndex = 1;

    int registerConstant(IConstantOperand c) {
        int idx = this.indexOf(c);
        if (idx >= 0) {
            return ((IConstantOperand)this.get(idx)).getIndexInConstantPool();
        }
        this.add(c);
        idx = this.nextIndex;
        this.nextIndex += c.size();
        return idx;
    }

    public void write(ByteWriter writer) throws CompilerException {
        writer.writeU2(this.nextIndex);
        this.forEach(c -> c.writeTo(writer));
    }

    public IConstantOperand constantWithIndex(int index) {
        for (IConstantOperand operand : this) {
            if (operand.getIndexInConstantPool() != index) continue;
            return operand;
        }
        return null;
    }
}

