/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import prompto.compiler.CompilerUtils;

public abstract class Descriptor {
    protected Type[] types;
    protected String descriptor;

    public String toString() {
        return this.descriptor;
    }

    public Type getLastType() {
        return this.types[this.types.length - 1];
    }

    public Type[] getTypes() {
        return this.types;
    }

    public String getLastDescriptor() {
        return CompilerUtils.getDescriptor(this.getLastType());
    }

    public static class Method
    extends Descriptor {
        public Method(Type ... types) {
            this.types = types;
            this.descriptor = CompilerUtils.createProto(types);
        }

        public Method(Type[] parameterTypes, Type returnType) {
            ArrayList<Type> types = new ArrayList<Type>();
            types.addAll(Arrays.asList(parameterTypes));
            types.add(returnType);
            this.types = types.toArray(new Type[types.size()]);
            this.descriptor = CompilerUtils.createProto(this.types);
        }
    }

    public static class Field
    extends Descriptor {
        public Field(Type type) {
            this.types = new Type[]{type};
            this.descriptor = CompilerUtils.getDescriptor(type);
        }
    }
}

