/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import prompto.compiler.ByteWriter;
import prompto.compiler.ConstantsPool;
import prompto.compiler.IValueConstant;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.StackEntry;

public class DoubleConstant
implements IValueConstant {
    double value;
    int index;

    public DoubleConstant(double value) {
        this.value = value;
    }

    @Override
    public int getTag() {
        return 6;
    }

    @Override
    public StackEntry toStackEntry() {
        return IVerifierEntry.VerifierType.ITEM_Double.newStackEntry(null);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int size() {
        return 2;
    }

    public boolean equals(Object obj) {
        return obj instanceof DoubleConstant && this.value == ((DoubleConstant)obj).value;
    }

    @Override
    public int getIndexInConstantPool() {
        return this.index;
    }

    @Override
    public void register(ConstantsPool pool) {
        this.index = pool.registerConstant(this);
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU1(6);
        long l = Double.doubleToLongBits(this.value);
        writer.writeU4((int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL));
        writer.writeU4((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }
}

