/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import prompto.compiler.ByteWriter;
import prompto.compiler.ClassConstant;
import prompto.compiler.CodeAttribute;
import prompto.compiler.ConstantsPool;
import prompto.compiler.IInstruction;
import prompto.compiler.IInstructionListener;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.StackEntry;
import prompto.compiler.StackLabel;
import prompto.compiler.StackState;

public class ExceptionHandler
implements IInstructionListener {
    boolean active = false;
    int startPC = -1;
    int endPC = -1;
    ClassConstant exception;
    StackState state;
    StackLabel label;

    public ExceptionHandler(Type type) {
        this.exception = type == null ? null : new ClassConstant(type);
    }

    public ClassConstant getException() {
        return this.exception;
    }

    public void setStackState(StackState state) {
        this.state = state;
    }

    public StackState getStackState() {
        return this.state;
    }

    public void setLabel(StackLabel label) {
        this.label = label;
    }

    public StackLabel getLabel() {
        return this.label;
    }

    public void register(ConstantsPool pool) {
        this.exception.register(pool);
    }

    @Override
    public void activate(IInstructionListener.Phase phase) {
        if (phase == IInstructionListener.Phase.WRITE) {
            this.active = true;
        }
    }

    @Override
    public void inhibit(IInstructionListener.Phase phase) {
        if (phase == IInstructionListener.Phase.WRITE) {
            this.active = false;
        }
    }

    @Override
    public void onAfterRehearse(IInstruction instruction) {
        if (instruction instanceof CodeAttribute.CaptureStackState) {
            this.onAfterRehearse((CodeAttribute.CaptureStackState)instruction);
        }
    }

    private void onAfterRehearse(CodeAttribute.CaptureStackState capture) {
        if (this.state == capture.getState()) {
            this.state.pushEntry(new StackEntry.ObjectEntry(IVerifierEntry.VerifierType.ITEM_Object, this.exception));
        }
    }

    @Override
    public void onBeforeWriteTo(ByteWriter writer, IInstruction instruction) {
        if (this.active) {
            if (this.startPC == -1) {
                this.startPC = writer.length();
            }
            this.endPC = writer.length();
        }
    }

    public void writeTo(ByteWriter writer) {
        if (this.startPC == -1) {
            throw new UnsupportedOperationException();
        }
        writer.writeU2(this.startPC);
        if (this.endPC == -1) {
            throw new UnsupportedOperationException();
        }
        writer.writeU2(this.endPC);
        if (this.label == null || this.label.getRealOffset() < 0) {
            throw new UnsupportedOperationException();
        }
        writer.writeU2(this.label.getRealOffset());
        writer.writeU2(this.exception.getIndexInConstantPool());
    }
}

