/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import prompto.compiler.ByteWriter;
import prompto.compiler.ClassConstant;
import prompto.compiler.ConstantsPool;
import prompto.compiler.Descriptor;
import prompto.compiler.ICodeConstant;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.NameAndTypeConstant;
import prompto.compiler.StackEntry;

public class FieldConstant
implements ICodeConstant {
    ClassConstant className;
    NameAndTypeConstant fieldNameAndType;
    int index;

    public FieldConstant(Type className, String fieldName, Type fieldType) {
        this.className = new ClassConstant(className);
        this.fieldNameAndType = new NameAndTypeConstant(fieldName, new Descriptor.Field(fieldType));
    }

    public FieldConstant(ClassConstant className, String fieldName, Type fieldType) {
        this.className = className;
        this.fieldNameAndType = new NameAndTypeConstant(fieldName, new Descriptor.Field(fieldType));
    }

    public FieldConstant(ClassConstant className, NameAndTypeConstant fieldNameAndType) {
        this.className = className;
        this.fieldNameAndType = fieldNameAndType;
    }

    @Override
    public int getTag() {
        return 9;
    }

    public ClassConstant getClassName() {
        return this.className;
    }

    public Type getType() {
        return this.fieldNameAndType.getDescriptor().getLastType();
    }

    public String toString() {
        return this.className.toString() + ':' + this.fieldNameAndType.toString();
    }

    public StackEntry toStackEntry() {
        Descriptor descriptor = this.fieldNameAndType.getDescriptor();
        IVerifierEntry.VerifierType type = IVerifierEntry.VerifierType.fromDescriptor(descriptor);
        StackEntry entry = type.newStackEntry(null);
        if (entry instanceof StackEntry.ObjectEntry) {
            ((StackEntry.ObjectEntry)entry).setClassName(new ClassConstant(this.fieldNameAndType.getDescriptor().getLastType()));
        }
        return entry;
    }

    @Override
    public int getIndexInConstantPool() {
        if (this.index == -1) {
            throw new UnsupportedOperationException();
        }
        return this.index;
    }

    @Override
    public void register(ConstantsPool pool) {
        this.index = pool.registerConstant(this);
        this.className.register(pool);
        this.fieldNameAndType.register(pool);
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU1(9);
        writer.writeU2(this.className.getIndexInConstantPool());
        writer.writeU2(this.fieldNameAndType.getIndexInConstantPool());
    }
}

