/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import prompto.compiler.ByteWriter;
import prompto.compiler.CompilerUtils;
import prompto.compiler.ConstantsPool;
import prompto.compiler.IAttribute;
import prompto.compiler.Utf8Constant;

public class FieldInfo {
    int accessFlags = 4;
    Type type;
    Utf8Constant name;
    Utf8Constant desc;
    List<IAttribute> attributes = new LinkedList<IAttribute>();

    public FieldInfo(String name, Type type) {
        this.type = type;
        this.name = new Utf8Constant(name);
        this.desc = new Utf8Constant(CompilerUtils.getDescriptor(type));
    }

    public void addModifier(int modifier) {
        this.accessFlags |= modifier;
    }

    public void clearModifier(int modifier) {
        this.accessFlags &= ~modifier;
    }

    public Utf8Constant getName() {
        return this.name;
    }

    public Utf8Constant getDescriptor() {
        return this.desc;
    }

    public Type getType() {
        return this.type;
    }

    void register(ConstantsPool pool) {
        this.name.register(pool);
        this.desc.register(pool);
        this.attributes.forEach(a -> a.register(pool));
    }

    void writeTo(ByteWriter writer) {
        writer.writeU2(this.accessFlags);
        writer.writeU2(this.name.getIndexInConstantPool());
        writer.writeU2(this.desc.getIndexInConstantPool());
        writer.writeU2(this.attributes.size());
        this.attributes.forEach(a -> a.writeTo(writer));
    }
}

