/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import prompto.compiler.FieldInfo;
import prompto.compiler.IInstructionListener;
import prompto.compiler.Opcode;
import prompto.grammar.CmpOp;

public class Flags {
    Map<String, Object> values;

    public Flags() {
        this.values = new HashMap<String, Object>();
        this.values.put("primitive", false);
        this.values.put("reverse", false);
        this.values.put("roughly", false);
        this.values.put("decimal", false);
        this.values.put("member", false);
        this.values.put("inline", false);
        this.values.put("opcode", null);
        this.values.put("getter", null);
        this.values.put("setter", null);
        this.values.put("variable", null);
        this.values.put("loopListeners", null);
    }

    private Flags(Map<String, Object> values) {
        this.values = values;
    }

    private Flags clone(String key, Object value) {
        HashMap<String, Object> values = new HashMap<String, Object>(this.values);
        values.put(key, value);
        return new Flags(values);
    }

    public boolean toPrimitive() {
        return (Boolean)this.values.get("primitive");
    }

    public Flags withPrimitive(boolean set) {
        return this.clone("primitive", set);
    }

    public Type toReturnType() {
        return (Type)this.values.get("returnType");
    }

    public Flags withReturnType(Type type) {
        return this.clone("returnType", type);
    }

    public boolean isReverse() {
        return (Boolean)this.values.get("reverse");
    }

    public Flags withReverse(boolean set) {
        return this.clone("reverse", set);
    }

    public boolean isDecimal() {
        return (Boolean)this.values.get("decimal");
    }

    public Flags withDecimal(boolean set) {
        return this.clone("decimal", set);
    }

    public Opcode opcode() {
        return (Opcode)((Object)this.values.get("opcode"));
    }

    public Flags withOpcode(Opcode opcode) {
        return this.clone("opcode", (Object)opcode);
    }

    public boolean isRoughly() {
        return (Boolean)this.values.get("roughly");
    }

    public Flags withRoughly(boolean set) {
        return this.clone("roughly", set);
    }

    public CmpOp cmpOp() {
        return (CmpOp)((Object)this.values.get("CmpOp"));
    }

    public Flags withCmpOp(CmpOp operator) {
        return this.clone("CmpOp", (Object)operator);
    }

    public FieldInfo setter() {
        return (FieldInfo)this.values.get("setter");
    }

    public Flags withSetter(FieldInfo field) {
        return this.clone("setter", field);
    }

    public FieldInfo getter() {
        return (FieldInfo)this.values.get("getter");
    }

    public Flags withGetter(FieldInfo field) {
        return this.clone("getter", field);
    }

    public String variable() {
        return (String)this.values.get("variable");
    }

    public Flags withVariable(String variable) {
        return this.clone("variable", variable);
    }

    public boolean isMember() {
        return (Boolean)this.values.get("member");
    }

    public Flags withMember(boolean set) {
        return this.clone("member", set);
    }

    public boolean isInline() {
        return (Boolean)this.values.get("inline");
    }

    public Flags withInline(boolean set) {
        return this.clone("inline", set);
    }

    public List<IInstructionListener> getBreakLoopListeners() {
        return (List)this.values.get("loopListeners");
    }

    public Flags withBreakLoopListeners(List<IInstructionListener> listeners) {
        return this.clone("loopListeners", listeners);
    }

    public void addBreakLoopListener(IInstructionListener listener) {
        this.getBreakLoopListeners().add(listener);
    }
}

