/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import prompto.compiler.ByteWriter;
import prompto.compiler.ClassConstant;
import prompto.compiler.ConstantsPool;
import prompto.compiler.Descriptor;
import prompto.compiler.StackEntry;
import prompto.compiler.StackLocal;

public interface IVerifierEntry {
    public VerifierType getType();

    public int length();

    default public void register(ConstantsPool pool) {
    }

    public void writeTo(ByteWriter var1);

    public static enum VerifierType {
        ITEM_Top(TopFactory.instance),
        ITEM_Integer(PrimitiveFactory.instance),
        ITEM_Float(PrimitiveFactory.instance),
        ITEM_Double(2, PrimitiveFactory.instance),
        ITEM_Long(2, PrimitiveFactory.instance),
        ITEM_Null(PrimitiveFactory.instance),
        ITEM_UninitializedThis(ThisFactory.instance),
        ITEM_Object(ObjectFactory.instance),
        ITEM_Uninitialized(ObjectFactory.instance);

        final short size;
        final IFactory entryFactory;

        private VerifierType() {
            this.size = 1;
            this.entryFactory = null;
        }

        private VerifierType(IFactory entryFactory) {
            this.size = 1;
            this.entryFactory = entryFactory;
        }

        private VerifierType(int size, IFactory entryFactory) {
            this.size = (short)size;
            this.entryFactory = entryFactory;
        }

        public void writeTo(ByteWriter writer) {
            writer.writeU1(this.ordinal());
        }

        public short size() {
            return this.size;
        }

        public StackEntry newStackEntry(ClassConstant className) {
            if (this.entryFactory == null) {
                throw new UnsupportedOperationException();
            }
            return this.entryFactory.newStackEntry(this, className);
        }

        public StackLocal newStackLocal(String name, ClassConstant className) {
            if (this.entryFactory == null) {
                throw new UnsupportedOperationException();
            }
            return this.entryFactory.newStackLocal(this, name, className);
        }

        public static VerifierType fromDescriptor(Descriptor descriptor) {
            return VerifierType.fromDescriptor(descriptor.toString());
        }

        public static VerifierType fromDescriptor(String desc) {
            switch (desc.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    return ITEM_Integer;
                }
                case 'F': {
                    return ITEM_Float;
                }
                case 'D': {
                    return ITEM_Double;
                }
                case 'J': {
                    return ITEM_Long;
                }
                case 'L': 
                case '[': {
                    return ITEM_Object;
                }
                case 'V': {
                    return null;
                }
            }
            throw new UnsupportedOperationException(desc);
        }

        static class ThisFactory
        extends ObjectFactory {
            static ThisFactory instance = new ThisFactory();

            ThisFactory() {
            }

            @Override
            public StackLocal newStackLocal(VerifierType type, String name, ClassConstant className) {
                if (!"this".equals(name)) {
                    throw new UnsupportedOperationException();
                }
                return new StackLocal.ThisLocal(className);
            }
        }

        static class ObjectFactory
        implements IFactory {
            static ObjectFactory instance = new ObjectFactory();

            ObjectFactory() {
            }

            @Override
            public StackEntry newStackEntry(VerifierType type, ClassConstant className) {
                return new StackEntry.ObjectEntry(type, className);
            }

            @Override
            public StackLocal newStackLocal(VerifierType type, String name, ClassConstant className) {
                return new StackLocal.ObjectLocal(type, name, className);
            }
        }

        static class TopFactory
        implements IFactory {
            static TopFactory instance = new TopFactory();

            TopFactory() {
            }

            @Override
            public StackEntry newStackEntry(VerifierType type, ClassConstant className) {
                return new StackEntry.TopEntry(type, className);
            }

            @Override
            public StackLocal newStackLocal(VerifierType type, String name, ClassConstant className) {
                return new StackLocal.TopLocal(name, className);
            }
        }

        static class PrimitiveFactory
        implements IFactory {
            static PrimitiveFactory instance = new PrimitiveFactory();

            PrimitiveFactory() {
            }

            @Override
            public StackEntry newStackEntry(VerifierType type, ClassConstant className) {
                return new StackEntry.PrimitiveEntry(type);
            }

            @Override
            public StackLocal newStackLocal(VerifierType type, String name, ClassConstant className) {
                return new StackLocal.PrimitiveLocal(type, name);
            }
        }

        static interface IFactory {
            public StackEntry newStackEntry(VerifierType var1, ClassConstant var2);

            public StackLocal newStackLocal(VerifierType var1, String var2, ClassConstant var3);
        }
    }
}

