/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import prompto.compiler.ByteWriter;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.ConstantsPool;
import prompto.compiler.MethodInfo;
import prompto.compiler.Utf8Constant;

public class InnerClassInfo {
    ClassFile classFile;
    ClassConstant innerClass;
    ClassConstant outerClass;
    Utf8Constant simpleName;
    int accessFlags = 41;

    public InnerClassInfo(ClassFile classFile, ClassConstant outerClass) {
        this.classFile = classFile;
        this.innerClass = classFile.getThisClass().clone();
        this.outerClass = outerClass;
        this.simpleName = new Utf8Constant(this.innerClass.getSimpleName());
    }

    public InnerClassInfo(ClassFile classFile, MethodInfo method) {
        this.classFile = classFile;
        this.innerClass = classFile.getThisClass().clone();
        this.outerClass = method.getClassFile().getThisClass();
        this.simpleName = new Utf8Constant(this.innerClass.getSimpleName());
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public void register(ConstantsPool pool) {
        this.innerClass.register(pool);
        this.outerClass.register(pool);
        this.simpleName.register(pool);
    }

    public void writeTo(ByteWriter writer) {
        writer.writeU2(this.innerClass.getIndexInConstantPool());
        writer.writeU2(this.outerClass.getIndexInConstantPool());
        writer.writeU2(this.simpleName.getIndexInConstantPool());
        writer.writeU2(this.accessFlags);
    }
}

