/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.util.ArrayList;
import java.util.List;
import prompto.compiler.ByteWriter;
import prompto.compiler.ConstantsPool;
import prompto.compiler.IAttribute;
import prompto.compiler.InnerClassInfo;
import prompto.compiler.Utf8Constant;

public class InnerClassesAttribute
implements IAttribute {
    Utf8Constant attributeName = new Utf8Constant("InnerClasses");
    List<InnerClassInfo> classes = new ArrayList<InnerClassInfo>();

    public List<InnerClassInfo> getClasses() {
        return this.classes;
    }

    public void addInnerClass(InnerClassInfo info) {
        this.classes.add(info);
    }

    @Override
    public void register(ConstantsPool pool) {
        this.attributeName.register(pool);
        this.classes.forEach(c -> c.register(pool));
    }

    @Override
    public int lengthWithoutHeader() {
        return 2 + 8 * this.classes.size();
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU2(this.attributeName.getIndexInConstantPool());
        writer.writeU4(this.lengthWithoutHeader());
        writer.writeU2(this.classes.size());
        this.classes.forEach(c -> c.writeTo(writer));
    }
}

