/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import prompto.compiler.ByteOperand;
import prompto.compiler.ByteWriter;
import prompto.compiler.CallSiteConstant;
import prompto.compiler.ClassConstant;
import prompto.compiler.CodeAttribute;
import prompto.compiler.ConstantsPool;
import prompto.compiler.DumpLevel;
import prompto.compiler.FieldConstant;
import prompto.compiler.IConstantOperand;
import prompto.compiler.IInstruction;
import prompto.compiler.IOperand;
import prompto.compiler.IValueConstant;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ShortOperand;
import prompto.compiler.StackEntry;
import prompto.compiler.StackMapTableAttribute;

public class Instruction
implements IInstruction {
    Opcode opcode;
    IOperand[] operands;

    Instruction(Opcode opcode, IOperand[] operands) {
        this.opcode = opcode;
        this.operands = operands;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.opcode.name());
        sb.append(' ');
        if (this.operands == null || this.operands.length == 0) {
            sb.append("[]");
        } else {
            sb.append('[');
            for (IOperand o : this.operands) {
                sb.append(o.toString());
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public void rehearse(CodeAttribute code) {
        this.updateStack(code.getStackMapTable());
    }

    @Override
    public void register(ConstantsPool pool) {
        for (IOperand operand : this.operands) {
            if (!(operand instanceof IConstantOperand)) continue;
            ((IConstantOperand)operand).register(pool);
        }
    }

    @Override
    public void writeTo(ByteWriter writer) {
        this.writeByteCode(writer);
        this.writeOperands(writer);
    }

    private void writeOperands(ByteWriter writer) {
        if (this.opcode.kind.length == -1) {
            throw new UnsupportedOperationException();
        }
        if (this.operands.length > 0) {
            switch (this.opcode.kind) {
                case BYTE: {
                    writer.writeU1(((ByteOperand)this.operands[0]).value());
                    break;
                }
                case SHORT: {
                    writer.writeU2(((ShortOperand)this.operands[0]).value());
                    break;
                }
                case BRANCH: {
                    writer.writeU2(((ShortOperand)this.operands[0]).value());
                    break;
                }
                case LOCAL: {
                    writer.writeU1(((ByteOperand)this.operands[0]).value());
                    break;
                }
                case LOCAL_BYTE: {
                    writer.writeU1(((ByteOperand)this.operands[0]).value());
                    writer.writeU1(((ByteOperand)this.operands[1]).value());
                    break;
                }
                case CPREF: {
                    writer.writeU1(((IConstantOperand)this.operands[0]).getIndexInConstantPool());
                    break;
                }
                case CPREF_W: {
                    writer.writeU2(((IConstantOperand)this.operands[0]).getIndexInConstantPool());
                    break;
                }
                case CPREF_W_UBYTE_ZERO: {
                    if (this.opcode == Opcode.INVOKEDYNAMIC) {
                        writer.writeU2(((IConstantOperand)this.operands[0]).getIndexInConstantPool());
                        writer.writeU2(0);
                        break;
                    }
                    writer.writeU2(((IConstantOperand)this.operands[0]).getIndexInConstantPool());
                    writer.writeU1(((InterfaceConstant)this.operands[0]).getArgsCount());
                    writer.writeU1(0);
                    break;
                }
                case NO_OPERANDS: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.opcode.kind.name());
                }
            }
        }
    }

    private void writeByteCode(ByteWriter writer) {
        if (this.opcode.kind.width == 1) {
            writer.writeU1(this.opcode.opcode);
        } else {
            writer.writeU2(this.opcode.opcode);
        }
    }

    private void updateStack(StackMapTableAttribute stack) {
        if (DumpLevel.current() == DumpLevel.STACK) {
            System.err.println(this.toString());
            System.err.println("Before pop: " + stack.getState().toString());
        }
        StackEntry[] popped = stack.pop(this.opcode.getPopped(this));
        if (DumpLevel.current() == DumpLevel.STACK) {
            System.err.println("After pop: " + stack.getState().toString());
        }
        StackEntry[] pushed = this.opcode.getPushed(this, popped);
        stack.push(pushed);
        if (DumpLevel.current() == DumpLevel.STACK) {
            System.err.println("After push: " + stack.getState().toString());
            System.err.println();
        } else if (DumpLevel.current() == DumpLevel.OPCODE) {
            System.err.println("(" + this.opcode.kind.length + ") " + this.toString() + " -> " + stack.getState().toString());
        }
    }

    public ClassConstant getClassConstant() {
        for (IOperand operand : this.operands) {
            if (!(operand instanceof ClassConstant)) continue;
            return (ClassConstant)operand;
        }
        return null;
    }

    public CallSiteConstant getCallSiteConstant() {
        for (IOperand operand : this.operands) {
            if (!(operand instanceof CallSiteConstant)) continue;
            return (CallSiteConstant)operand;
        }
        return null;
    }

    public MethodConstant getMethodConstant() {
        for (IOperand operand : this.operands) {
            if (!(operand instanceof MethodConstant)) continue;
            return (MethodConstant)operand;
        }
        return null;
    }

    public FieldConstant getFieldConstant() {
        for (IOperand operand : this.operands) {
            if (!(operand instanceof FieldConstant)) continue;
            return (FieldConstant)operand;
        }
        return null;
    }

    public IValueConstant getValueConstant() {
        for (IOperand operand : this.operands) {
            if (!(operand instanceof IValueConstant)) continue;
            return (IValueConstant)operand;
        }
        return null;
    }

    public StackEntry getConstantStackEntry() {
        IValueConstant v = this.getValueConstant();
        return v.toStackEntry();
    }

    public StackEntry getFieldStackEntry() {
        FieldConstant f = this.getFieldConstant();
        return f.toStackEntry();
    }

    public StackEntry getMethodResultStackEntry() {
        if (this.opcode == Opcode.INVOKEDYNAMIC) {
            CallSiteConstant c = this.getCallSiteConstant();
            return c.resultToStackEntry();
        }
        MethodConstant m = this.getMethodConstant();
        return m.resultToStackEntry();
    }

    public short getArgumentsCount(boolean isStatic) {
        if (this.opcode == Opcode.INVOKEDYNAMIC) {
            CallSiteConstant c = this.getCallSiteConstant();
            return c.getArgumentsCount(isStatic);
        }
        MethodConstant m = this.getMethodConstant();
        return m.getArgumentsCount(isStatic);
    }
}

