/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.compiler.CompilerUtils;
import prompto.compiler.SignatureAttribute;
import prompto.grammar.ParameterList;
import prompto.runtime.Context;
import prompto.type.IType;
import prompto.type.VoidType;

public class InterfaceType {
    ParameterList arguments;
    IType returnType;

    public InterfaceType(ParameterList arguments, IType returnType) {
        this.arguments = arguments;
        this.returnType = returnType;
    }

    public boolean isVoid() {
        return this.returnType == VoidType.instance();
    }

    public Type getInterfaceType() {
        if (this.isVoid()) {
            switch (this.arguments.size()) {
                case 0: {
                    return Runnable.class;
                }
                case 1: {
                    return Consumer.class;
                }
                case 2: {
                    return BiConsumer.class;
                }
            }
            throw new UnsupportedOperationException("getConsumerType " + this.arguments.size());
        }
        switch (this.arguments.size()) {
            case 0: {
                return Supplier.class;
            }
            case 1: {
                return Function.class;
            }
            case 2: {
                return BiFunction.class;
            }
        }
        throw new UnsupportedOperationException("getSupplierType " + this.arguments.size());
    }

    public String getInterfaceMethodName() {
        if (this.isVoid()) {
            switch (this.arguments.size()) {
                case 0: {
                    return "run";
                }
            }
            return "accept";
        }
        switch (this.arguments.size()) {
            case 0: {
                return "get";
            }
        }
        return "apply";
    }

    public SignatureAttribute computeSignature(Context context, Type superClass) {
        String scs = CompilerUtils.getDescriptor(superClass);
        Stream<IType> types = this.arguments.stream().map(arg -> arg.getType(context));
        if (!this.isVoid()) {
            types = Stream.concat(types, Stream.of(this.returnType));
        }
        List<Type> javaTypes = types.map(t -> t.getJavaType(context)).collect(Collectors.toList());
        String sis = CompilerUtils.getGenericDescriptor(this.getInterfaceType(), javaTypes);
        return new SignatureAttribute(scs + sis);
    }
}

