/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import prompto.compiler.ByteWriter;
import prompto.compiler.CompilerException;
import prompto.compiler.ConstantsPool;
import prompto.compiler.IAttribute;
import prompto.compiler.StackLocal;
import prompto.compiler.Utf8Constant;

public class LocalVariableTableAttribute
implements IAttribute {
    Utf8Constant attributeName = new Utf8Constant("LocalVariableTable");
    private Map<String, StackLocal> entries = new HashMap<String, StackLocal>();

    public int numLocals() {
        return this.entries.size();
    }

    public List<StackLocal> getEntries() {
        return this.entries.values().stream().sorted((a, b) -> Short.compare(a.getIndex(), b.getIndex())).collect(Collectors.toList());
    }

    public String nextTransientName(String core) {
        String name;
        int i = 0;
        while (this.entries.containsKey(name = String.format("%%%s-%03d%%", core, i++))) {
        }
        return name;
    }

    public StackLocal registerLocal(StackLocal local) {
        String name = local.getName();
        StackLocal current = this.entries.get(name);
        if (current != null) {
            return current;
        }
        int idx = this.entries.size();
        local.setIndex((short)idx);
        this.entries.put(name, local);
        return local;
    }

    public void unregisterLocal(StackLocal local) {
        short index = local.getIndex();
        if (index != this.entries.size() - 1) {
            throw new CompilerException("Can only unregister top local!");
        }
        this.entries.remove(local.getName());
    }

    public StackLocal getRegisteredLocal(String name) {
        return this.entries.get(name);
    }

    @Override
    public void register(ConstantsPool pool) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lengthWithoutHeader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(ByteWriter writer) {
        throw new UnsupportedOperationException();
    }
}

