/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import prompto.compiler.ByteWriter;
import prompto.compiler.ConstantsPool;
import prompto.compiler.IValueConstant;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.StackEntry;

public class LongConstant
implements IValueConstant {
    long value;
    int index;

    public LongConstant(long value) {
        this.value = value;
    }

    @Override
    public int getTag() {
        return 5;
    }

    @Override
    public StackEntry toStackEntry() {
        return IVerifierEntry.VerifierType.ITEM_Long.newStackEntry(null);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int size() {
        return 2;
    }

    public boolean equals(Object obj) {
        return obj instanceof LongConstant && this.value == ((LongConstant)obj).value;
    }

    @Override
    public int getIndexInConstantPool() {
        return this.index;
    }

    @Override
    public void register(ConstantsPool pool) {
        this.index = pool.registerConstant(this);
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU1(5);
        writer.writeU4((int)(this.value >> 32 & 0xFFFFFFFFFFFFFFFFL));
        writer.writeU4((int)(this.value & 0xFFFFFFFFFFFFFFFFL));
    }
}

