/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import prompto.compiler.ByteWriter;
import prompto.compiler.ClassConstant;
import prompto.compiler.ConstantsPool;
import prompto.compiler.Descriptor;
import prompto.compiler.ICodeConstant;
import prompto.compiler.NameAndTypeConstant;
import prompto.compiler.StackEntry;

public class MethodConstant
implements ICodeConstant {
    ClassConstant className;
    NameAndTypeConstant methodNameAndType;
    int index;

    public MethodConstant(Type klass, String methodName, Type ... params) {
        this(new ClassConstant(klass), methodName, new Descriptor.Method(params));
    }

    public MethodConstant(Type klass, String methodName, Descriptor.Method method) {
        this(new ClassConstant(klass), methodName, method);
    }

    public MethodConstant(ClassConstant klass, String methodName, Type ... params) {
        this(klass, methodName, new Descriptor.Method(params));
    }

    public MethodConstant(ClassConstant klass, String methodName, Descriptor.Method method) {
        this(klass, new NameAndTypeConstant(methodName, method));
    }

    public MethodConstant(ClassConstant klass, NameAndTypeConstant nameAndType) {
        this.className = klass;
        this.methodNameAndType = nameAndType;
    }

    @Override
    public int getTag() {
        return 10;
    }

    public ClassConstant getClassName() {
        return this.className;
    }

    public NameAndTypeConstant getMethodNameAndType() {
        return this.methodNameAndType;
    }

    public short getArgumentsCount(boolean isStatic) {
        return this.methodNameAndType.getArgumentsCount(isStatic);
    }

    public StackEntry resultToStackEntry() {
        return this.methodNameAndType.resultToStackEntry();
    }

    public String toString() {
        return this.className.toString() + ':' + this.methodNameAndType.toString();
    }

    @Override
    public int getIndexInConstantPool() {
        if (this.index == -1) {
            throw new UnsupportedOperationException();
        }
        return this.index;
    }

    @Override
    public void register(ConstantsPool pool) {
        this.index = pool.registerConstant(this);
        this.className.register(pool);
        this.methodNameAndType.register(pool);
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU1(10);
        writer.writeU2(this.className.getIndexInConstantPool());
        writer.writeU2(this.methodNameAndType.getIndexInConstantPool());
    }
}

