/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import prompto.compiler.ByteWriter;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CodeAttribute;
import prompto.compiler.ConstantsPool;
import prompto.compiler.Descriptor;
import prompto.compiler.DumpLevel;
import prompto.compiler.ExceptionHandler;
import prompto.compiler.IAttribute;
import prompto.compiler.IInstruction;
import prompto.compiler.IInstructionListener;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.Instruction;
import prompto.compiler.LocalVariableTableAttribute;
import prompto.compiler.Opcode;
import prompto.compiler.StackLabel;
import prompto.compiler.StackLocal;
import prompto.compiler.StackLocals;
import prompto.compiler.StackState;
import prompto.compiler.Utf8Constant;

public class MethodInfo {
    int accessFlags = 1;
    Utf8Constant name;
    Utf8Constant signature;
    List<IAttribute> attributes = new LinkedList<IAttribute>();
    CodeAttribute codeAttribute = null;
    Descriptor descriptor;
    ClassFile classFile;

    MethodInfo(ClassFile classFile, String name, Descriptor.Method descriptor) {
        this.classFile = classFile;
        this.descriptor = descriptor;
        this.name = new Utf8Constant(name);
        this.signature = new Utf8Constant(descriptor.toString());
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public Utf8Constant getName() {
        return this.name;
    }

    public Utf8Constant getSignature() {
        return this.signature;
    }

    public CodeAttribute getCodeAttribute() {
        return this.codeAttribute;
    }

    public LocalVariableTableAttribute getLocals() {
        this.ensureCodeAttribute();
        return this.codeAttribute.getLocals();
    }

    public String toString() {
        return this.name.toString() + '/' + this.signature.toString();
    }

    public void addModifier(int modifier) {
        this.accessFlags |= modifier;
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public IInstruction addInstruction(Opcode op, IOperand ... operands) {
        return this.addInstruction(new Instruction(op, operands));
    }

    public <T extends IInstruction> T addInstruction(T instruction) {
        this.ensureCodeAttribute();
        return this.codeAttribute.addInstruction(instruction);
    }

    public <T extends IInstructionListener> T addOffsetListener(T listener) {
        this.ensureCodeAttribute();
        return this.codeAttribute.addOffsetListener(listener);
    }

    public IInstruction activateOffsetListener(IInstructionListener listener) {
        return this.codeAttribute.activateOffsetListener(listener);
    }

    public IInstruction inhibitOffsetListener(IInstructionListener listener) {
        return this.codeAttribute.inhibitOffsetListener(listener);
    }

    public StackLocal registerLocal(String name, IVerifierEntry.VerifierType type, ClassConstant className) {
        this.ensureCodeAttribute();
        return this.codeAttribute.registerLocal(type.newStackLocal(name, className));
    }

    public String nextTransientName(String core) {
        this.ensureCodeAttribute();
        return this.codeAttribute.nextTransientName(core);
    }

    public StackLocal getRegisteredLocal(String name) {
        this.ensureCodeAttribute();
        return this.codeAttribute.getRegisteredLocal(name);
    }

    public void unregisterLocal(StackLocal local) {
        this.codeAttribute.unregisterLocal(local);
    }

    public ExceptionHandler registerExceptionHandler(Type type) {
        this.ensureCodeAttribute();
        return this.codeAttribute.registerExceptionHandler(type);
    }

    public void placeExceptionHandler(ExceptionHandler handler) {
        this.codeAttribute.placeExceptionHandler(handler);
    }

    void register(ConstantsPool pool) {
        if (DumpLevel.current().ordinal() > 0) {
            System.err.println("Registering method: " + this.toString());
        }
        this.name.register(pool);
        this.signature.register(pool);
        this.attributes.forEach(a -> a.register(pool));
    }

    public CodeAttribute ensureCodeAttribute() {
        if (this.codeAttribute == null) {
            this.codeAttribute = new CodeAttribute();
            this.attributes.add(this.codeAttribute);
        }
        return this.codeAttribute;
    }

    public StackLocals captureStackLocals() {
        StackLocals locals = new StackLocals();
        locals.stackState = this.captureStackState();
        locals.numLocals = this.getLocals().numLocals();
        return locals;
    }

    public void restoreStackLocals(StackLocals stackLocals) {
        StackLocal local;
        List<StackLocal> locals = this.getLocals().getEntries();
        ListIterator<StackLocal> iterLocals = locals.listIterator(locals.size());
        while (iterLocals.hasPrevious() && (local = iterLocals.previous()).getIndex() >= stackLocals.numLocals) {
            this.unregisterLocal(local);
        }
        this.restoreStackLocals(stackLocals.stackState);
    }

    public StackState captureStackState() {
        this.ensureCodeAttribute();
        return this.codeAttribute.captureStackState();
    }

    public void restoreFullStackState(StackState state) {
        this.codeAttribute.restoreFullStackState(state);
    }

    public void restoreStackLocals(StackState state) {
        this.codeAttribute.restoreStackLocals(state);
    }

    public StackLabel placeLabel(StackState state) {
        this.ensureCodeAttribute();
        return this.codeAttribute.placeLabel(state);
    }

    void writeTo(ByteWriter writer) {
        writer.writeU2(this.accessFlags);
        writer.writeU2(this.name.getIndexInConstantPool());
        writer.writeU2(this.signature.getIndexInConstantPool());
        writer.writeU2(this.attributes.size());
        this.attributes.forEach(a -> a.writeTo(writer));
    }
}

