/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import prompto.compiler.ByteWriter;
import prompto.compiler.ClassConstant;
import prompto.compiler.ConstantsPool;
import prompto.compiler.Descriptor;
import prompto.compiler.ICodeConstant;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.StackEntry;
import prompto.compiler.Utf8Constant;

public class NameAndTypeConstant
implements ICodeConstant {
    Descriptor descriptor;
    Utf8Constant name;
    Utf8Constant type;
    int index;

    public NameAndTypeConstant(String name, Descriptor descriptor) {
        this.descriptor = descriptor;
        this.name = new Utf8Constant(name);
        this.type = new Utf8Constant(descriptor.toString());
    }

    @Override
    public int getTag() {
        return 12;
    }

    public String toString() {
        return this.name.toString() + '(' + this.type.toString() + ')';
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Utf8Constant getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj instanceof NameAndTypeConstant && this.name.equals(((NameAndTypeConstant)obj).name) && this.type.equals(((NameAndTypeConstant)obj).type);
    }

    @Override
    public int getIndexInConstantPool() {
        if (this.index == -1) {
            throw new UnsupportedOperationException();
        }
        return this.index;
    }

    @Override
    public void register(ConstantsPool pool) {
        this.index = pool.registerConstant(this);
        this.name.register(pool);
        this.type.register(pool);
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU1(12);
        writer.writeU2(this.name.getIndexInConstantPool());
        writer.writeU2(this.type.getIndexInConstantPool());
    }

    public short getArgumentsCount(boolean isStatic) {
        Type[] types = this.getDescriptor().getTypes();
        return (short)(types.length - (isStatic ? 1 : 0));
    }

    public StackEntry resultToStackEntry() {
        String descriptor = this.getDescriptor().getLastDescriptor();
        if ("V".equals(descriptor)) {
            return null;
        }
        IVerifierEntry.VerifierType type = IVerifierEntry.VerifierType.fromDescriptor(descriptor);
        StackEntry entry = type.newStackEntry(null);
        if (entry instanceof StackEntry.ObjectEntry) {
            ((StackEntry.ObjectEntry)entry).setClassName(new ClassConstant(this.getDescriptor().getLastType()));
        }
        return entry;
    }
}

