/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.util.function.Function;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.Instruction;
import prompto.compiler.OpcodeKind;
import prompto.compiler.StackEntry;

public enum Opcode {
    ILLEGAL(255, OpcodeKind.UNKNOWN, Opcode.popsNone(), Opcode.pushesNone()),
    NOP(0, Opcode.popsNone(), Opcode.pushesNone()),
    ACONST_NULL(1, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Null)),
    ICONST_M1(2, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    ICONST_0(3, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    ICONST_1(4, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    ICONST_2(5, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    ICONST_3(6, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    ICONST_4(7, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    ICONST_5(8, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    LCONST_0(9, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    LCONST_1(10, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    DCONST_0(14, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Double)),
    DCONST_1(15, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Double)),
    BIPUSH(16, OpcodeKind.BYTE, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    SIPUSH(17, OpcodeKind.SHORT, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    LDC(18, OpcodeKind.CPREF, Opcode.popsNone(), Opcode.pushesConstant()),
    LDC_W(19, OpcodeKind.CPREF_W, Opcode.popsNone(), Opcode.pushesConstant()),
    LDC2_W(20, OpcodeKind.CPREF_W, Opcode.popsNone(), Opcode.pushesConstant()),
    ILOAD(21, OpcodeKind.LOCAL, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    LLOAD(22, OpcodeKind.LOCAL, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    FLOAD(23, OpcodeKind.LOCAL, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Float)),
    DLOAD(24, OpcodeKind.LOCAL, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Double)),
    ALOAD(25, OpcodeKind.LOCAL, Opcode.popsNone(), Opcode.pushesObject()),
    ILOAD_0(26, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    ILOAD_1(27, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    ILOAD_2(28, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    ILOAD_3(29, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    LLOAD_0(30, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    LLOAD_1(31, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    LLOAD_2(32, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    LLOAD_3(33, Opcode.popsNone(), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    ALOAD_0(42, Opcode.popsNone(), Opcode.pushesObject()),
    ALOAD_1(43, Opcode.popsNone(), Opcode.pushesObject()),
    ALOAD_2(44, Opcode.popsNone(), Opcode.pushesObject()),
    ALOAD_3(45, Opcode.popsNone(), Opcode.pushesObject()),
    AALOAD(50, Opcode.pops(2), Opcode.pushesObject()),
    ISTORE(54, OpcodeKind.LOCAL, Opcode.pops(1), Opcode.pushesNone()),
    LSTORE(55, OpcodeKind.LOCAL, Opcode.pops(1), Opcode.pushesNone()),
    FSTORE(56, OpcodeKind.LOCAL, Opcode.pops(1), Opcode.pushesNone()),
    DSTORE(57, OpcodeKind.LOCAL, Opcode.pops(1), Opcode.pushesNone()),
    ASTORE(58, OpcodeKind.LOCAL, Opcode.pops(1), Opcode.pushesNone()),
    ISTORE_0(59, Opcode.pops(1), Opcode.pushesNone()),
    ISTORE_1(60, Opcode.pops(1), Opcode.pushesNone()),
    ISTORE_2(61, Opcode.pops(1), Opcode.pushesNone()),
    ISTORE_3(62, Opcode.pops(1), Opcode.pushesNone()),
    ASTORE_0(75, Opcode.pops(1), Opcode.pushesNone()),
    ASTORE_1(76, Opcode.pops(1), Opcode.pushesNone()),
    ASTORE_2(77, Opcode.pops(1), Opcode.pushesNone()),
    ASTORE_3(78, Opcode.pops(1), Opcode.pushesNone()),
    AASTORE(83, Opcode.pops(3), Opcode.pushesNone()),
    POP(87, Opcode.pops(1), Opcode.pushesNone()),
    POP2(88, Opcode.pops(2), Opcode.pushesNone()),
    DUP(89, Opcode.pops(1), Opcode.pushesDuplicate()),
    DUP_X1(90, Opcode.pops(2), Opcode.pushesDuplicateDown(1)),
    DUP_X2(91, Opcode.pops(3), Opcode.pushesDuplicateDown(2)),
    DUP2(92, Opcode.pops(2), Opcode.pushesDuplicateDown(1)),
    SWAP(95, Opcode.pops(2), Opcode.pushesSwapped()),
    IADD(96, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    LADD(97, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    DADD(99, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Double)),
    ISUB(100, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    LSUB(101, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    DSUB(103, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Double)),
    LMUL(105, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    DMUL(107, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Double)),
    LDIV(109, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    DDIV(111, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Double)),
    LREM(113, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    DREM(115, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Double)),
    INEG(116, Opcode.pops(1), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    LNEG(117, Opcode.pops(1), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    DNEG(119, Opcode.pops(1), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Double)),
    IAND(126, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    IINC(132, OpcodeKind.LOCAL_BYTE, Opcode.popsNone(), Opcode.pushesNone()),
    I2L(133, Opcode.pops(1), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    L2I(136, Opcode.pops(1), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    L2D(138, Opcode.pops(1), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Double)),
    F2D(141, Opcode.pops(1), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Double)),
    D2L(143, Opcode.pops(1), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Long)),
    I2C(146, Opcode.pops(1), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    LCMP(148, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    DCMPG(152, Opcode.pops(2), Opcode.pushes(IVerifierEntry.VerifierType.ITEM_Integer)),
    IFEQ(153, OpcodeKind.BRANCH, Opcode.pops(1), Opcode.pushesNone()),
    IFNE(154, OpcodeKind.BRANCH, Opcode.pops(1), Opcode.pushesNone()),
    IFLT(155, OpcodeKind.BRANCH, Opcode.pops(1), Opcode.pushesNone()),
    IFGE(156, OpcodeKind.BRANCH, Opcode.pops(1), Opcode.pushesNone()),
    IFGT(157, OpcodeKind.BRANCH, Opcode.pops(1), Opcode.pushesNone()),
    IFLE(158, OpcodeKind.BRANCH, Opcode.pops(1), Opcode.pushesNone()),
    IF_ICMPEQ(159, OpcodeKind.BRANCH, Opcode.pops(2), Opcode.pushesNone()),
    IF_ICMPNE(160, OpcodeKind.BRANCH, Opcode.pops(2), Opcode.pushesNone()),
    IF_ICMPLT(161, OpcodeKind.BRANCH, Opcode.pops(2), Opcode.pushesNone()),
    IF_ICMPGE(162, OpcodeKind.BRANCH, Opcode.pops(2), Opcode.pushesNone()),
    IF_ICMPGT(163, OpcodeKind.BRANCH, Opcode.pops(2), Opcode.pushesNone()),
    IF_ICMPLE(164, OpcodeKind.BRANCH, Opcode.pops(2), Opcode.pushesNone()),
    IF_ACMPEQ(165, OpcodeKind.BRANCH, Opcode.pops(2), Opcode.pushesNone()),
    IF_ACMPNE(166, OpcodeKind.BRANCH, Opcode.pops(2), Opcode.pushesNone()),
    GOTO(167, OpcodeKind.BRANCH, Opcode.popsNone(), Opcode.pushesNone()),
    IRETURN(172, Opcode.pops(1), Opcode.pushesNone()),
    LRETURN(173, Opcode.pops(1), Opcode.pushesNone()),
    FRETURN(174, Opcode.pops(1), Opcode.pushesNone()),
    DRETURN(175, Opcode.pops(1), Opcode.pushesNone()),
    ARETURN(176, Opcode.pops(1), Opcode.pushesNone()),
    RETURN(177, Opcode.popsNone(), Opcode.pushesNone()),
    GETSTATIC(178, OpcodeKind.CPREF_W, Opcode.popsNone(), Opcode.pushesField()),
    PUTSTATIC(179, OpcodeKind.CPREF_W, Opcode.pops(1), Opcode.pushesNone()),
    GETFIELD(180, OpcodeKind.CPREF_W, Opcode.pops(1), Opcode.pushesField()),
    PUTFIELD(181, OpcodeKind.CPREF_W, Opcode.pops(2), Opcode.pushesNone()),
    INVOKEVIRTUAL(182, OpcodeKind.CPREF_W, Opcode.popsArguments(false), Opcode.pushesResult()),
    INVOKESPECIAL(183, OpcodeKind.CPREF_W, Opcode.popsArguments(false), Opcode.pushesResult()),
    INVOKESTATIC(184, OpcodeKind.CPREF_W, Opcode.popsArguments(true), Opcode.pushesResult()),
    INVOKEINTERFACE(185, OpcodeKind.CPREF_W_UBYTE_ZERO, Opcode.popsArguments(false), Opcode.pushesResult()),
    INVOKEDYNAMIC(186, OpcodeKind.CPREF_W_UBYTE_ZERO, Opcode.popsArguments(true), Opcode.pushesResult()),
    NEW(187, OpcodeKind.CPREF_W, Opcode.popsNone(), Opcode.pushesObject()),
    ANEWARRAY(189, OpcodeKind.CPREF_W, Opcode.pops(1), Opcode.pushesArray()),
    ATHROW(191, Opcode.pops(1), Opcode.pushesNone()),
    CHECKCAST(192, OpcodeKind.CPREF_W, Opcode.pops(1), Opcode.pushesObject()),
    MONITORENTER(194, Opcode.pops(1), Opcode.pushesNone()),
    MONITOREXIT(195, Opcode.pops(1), Opcode.pushesNone()),
    IFNULL(198, OpcodeKind.BRANCH, Opcode.pops(1), Opcode.pushesNone()),
    IFNONNULL(199, OpcodeKind.BRANCH, Opcode.pops(1), Opcode.pushesNone());

    public final int opcode;
    public final OpcodeKind kind;
    public final Popper popper;
    public final Pusher pusher;
    private static Opcode[] stdOpcodes;
    private static Opcode[] wideOpcodes;
    public static final int WIDE = 196;

    static Popper popsNone() {
        return new Popper(){

            @Override
            public Short apply(Instruction i) {
                return (short)0;
            }
        };
    }

    static Popper pops(final int count) {
        return new Popper(){

            @Override
            public Short apply(Instruction i) {
                return (short)count;
            }
        };
    }

    static Popper popsArguments(final boolean isStatic) {
        return new Popper(){

            @Override
            public Short apply(Instruction i) {
                return i.getArgumentsCount(isStatic);
            }
        };
    }

    static Pusher pushesNone() {
        return new Pusher(){

            @Override
            public StackEntry[] apply(Instruction i, StackEntry[] popped) {
                return new StackEntry[0];
            }
        };
    }

    static Pusher pushesDuplicate() {
        return new Pusher(){

            @Override
            public StackEntry[] apply(Instruction i, StackEntry[] popped) {
                return new StackEntry[]{popped[0], popped[0]};
            }
        };
    }

    static Pusher pushesDuplicateDown(final int downBy) {
        return new Pusher(){

            @Override
            public StackEntry[] apply(Instruction i, StackEntry[] popped) {
                switch (downBy) {
                    case 1: {
                        return new StackEntry[]{popped[1], popped[0], popped[1]};
                    }
                    case 2: {
                        return new StackEntry[]{popped[2], popped[0], popped[1], popped[2]};
                    }
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    static Pusher pushesSwapped() {
        return new Pusher(){

            @Override
            public StackEntry[] apply(Instruction i, StackEntry[] popped) {
                return new StackEntry[]{popped[1], popped[0]};
            }
        };
    }

    static Pusher pushesConstant() {
        return new Pusher(){

            @Override
            public StackEntry[] apply(Instruction i, StackEntry[] popped) {
                StackEntry[] stackEntryArray;
                StackEntry e = i.getConstantStackEntry();
                if (e == null) {
                    stackEntryArray = new StackEntry[]{};
                } else {
                    StackEntry[] stackEntryArray2 = new StackEntry[1];
                    stackEntryArray = stackEntryArray2;
                    stackEntryArray2[0] = e;
                }
                return stackEntryArray;
            }
        };
    }

    static Pusher pushesField() {
        return new Pusher(){

            @Override
            public StackEntry[] apply(Instruction i, StackEntry[] popped) {
                StackEntry[] stackEntryArray;
                StackEntry e = i.getFieldStackEntry();
                if (e == null) {
                    stackEntryArray = new StackEntry[]{};
                } else {
                    StackEntry[] stackEntryArray2 = new StackEntry[1];
                    stackEntryArray = stackEntryArray2;
                    stackEntryArray2[0] = e;
                }
                return stackEntryArray;
            }
        };
    }

    static Pusher pushesResult() {
        return new Pusher(){

            @Override
            public StackEntry[] apply(Instruction i, StackEntry[] popped) {
                StackEntry[] stackEntryArray;
                StackEntry e = i.getMethodResultStackEntry();
                if (e == null) {
                    stackEntryArray = new StackEntry[]{};
                } else {
                    StackEntry[] stackEntryArray2 = new StackEntry[1];
                    stackEntryArray = stackEntryArray2;
                    stackEntryArray2[0] = e;
                }
                return stackEntryArray;
            }
        };
    }

    static Pusher pushesObject() {
        return new Pusher(){

            @Override
            public StackEntry[] apply(Instruction i, StackEntry[] popped) {
                return new StackEntry[]{IVerifierEntry.VerifierType.ITEM_Object.newStackEntry(i.getClassConstant())};
            }
        };
    }

    static Pusher pushesArray() {
        return new Pusher(){

            @Override
            public StackEntry[] apply(Instruction i, StackEntry[] popped) {
                return new StackEntry[]{IVerifierEntry.VerifierType.ITEM_Object.newStackEntry(i.getClassConstant().toArray())};
            }
        };
    }

    static Pusher pushes(final IVerifierEntry.VerifierType e) {
        return new Pusher(){

            @Override
            public StackEntry[] apply(Instruction i, StackEntry[] popped) {
                return new StackEntry[]{e.newStackEntry(null)};
            }
        };
    }

    private Opcode(int opcode) {
        this(opcode, OpcodeKind.NO_OPERANDS, Opcode.popsNone(), Opcode.pushesNone());
    }

    private Opcode(int opcode, Popper popper, Pusher pusher) {
        this(opcode, OpcodeKind.NO_OPERANDS, popper, pusher);
    }

    private Opcode(int opcode, OpcodeKind kind, Popper popper, Pusher pusher) {
        this.opcode = opcode;
        this.kind = kind;
        this.popper = popper;
        this.pusher = pusher;
    }

    public short getPopped(Instruction i) {
        return (Short)this.popper.apply(i);
    }

    public StackEntry[] getPushed(Instruction instruction, StackEntry[] popped) {
        return this.pusher.apply(instruction, popped);
    }

    public static Opcode get(byte opcode) {
        return stdOpcodes[opcode & 0xFF];
    }

    public static Opcode get(byte opcodePrefix, byte opcode) {
        Opcode[] block = Opcode.getOpcodeBlock(opcodePrefix);
        return block == null ? null : block[opcode];
    }

    private static Opcode[] getOpcodeBlock(int opcodePrefix) {
        switch (opcodePrefix) {
            case 0: {
                return stdOpcodes;
            }
            case 196: {
                return wideOpcodes;
            }
        }
        return null;
    }

    static {
        stdOpcodes = new Opcode[256];
        wideOpcodes = new Opcode[256];
        Opcode[] opcodeArray = Opcode.values();
        int n = opcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Opcode o;
            Opcode.getOpcodeBlock((int)(o.opcode >> 8))[o.opcode & 0xFF] = o = opcodeArray[i];
        }
    }

    static interface Pusher {
        public StackEntry[] apply(Instruction var1, StackEntry[] var2);
    }

    static interface Popper
    extends Function<Instruction, Short> {
    }
}

