/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import prompto.compiler.Compiler;
import prompto.config.TempDirectories;
import prompto.error.SyntaxError;
import prompto.runtime.Context;
import prompto.runtime.Mode;
import prompto.utils.Logger;

public class PromptoClassLoader
extends URLClassLoader {
    static final Logger logger = new Logger();
    private static PromptoClassLoader instance = null;
    private static Boolean testMode;
    private static ThreadLocal<PromptoClassLoader> testInstance;
    Context context;

    private static ClassLoader getParentClassLoader() {
        return PromptoClassLoader.class.getClassLoader();
    }

    private static URL[] makeClassesDirURLs() {
        File classesDir = TempDirectories.getJavaClassesDir();
        try {
            URL[] urls = new URL[]{classesDir.toURI().toURL()};
            return urls;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static PromptoClassLoader getInstance() {
        return instance != null ? instance : testInstance.get();
    }

    public static PromptoClassLoader initialize(Context context) {
        return PromptoClassLoader.initialize(context, Mode.get() == Mode.UNITTEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PromptoClassLoader initialize(Context context, boolean testMode) {
        Class<PromptoClassLoader> clazz = PromptoClassLoader.class;
        synchronized (PromptoClassLoader.class) {
            boolean currentMode;
            if (PromptoClassLoader.testMode == null) {
                PromptoClassLoader.testMode = testMode;
            }
            if ((currentMode = PromptoClassLoader.testMode.booleanValue()) != testMode) {
                throw new UnsupportedOperationException("Cannot run test mode and regular mode in parallel!");
            }
            if (testMode) {
                if (testInstance == null) {
                    testInstance = new ThreadLocal();
                }
                testInstance.set(new PromptoClassLoader(context));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return testInstance.get();
            }
            if (instance != null) {
                throw new UnsupportedOperationException("Can only have one PromptoClassLoader!");
            }
            instance = new PromptoClassLoader(context);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninitialize() {
        Class<PromptoClassLoader> clazz = PromptoClassLoader.class;
        synchronized (PromptoClassLoader.class) {
            if (testMode == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (testMode.booleanValue()) {
                testInstance = null;
            } else {
                instance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private PromptoClassLoader(Context context) {
        super(PromptoClassLoader.makeClassesDirURLs(), PromptoClassLoader.getParentClassLoader());
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    File getClassDir() throws Exception {
        return Paths.get(this.getURLs()[0].toURI()).toFile();
    }

    @Override
    protected Class<?> findClass(String fullName) throws ClassNotFoundException {
        try {
            return super.findClass(fullName);
        }
        catch (ClassNotFoundException e) {
            if (fullName.charAt(0) == '\u03c0') {
                try {
                    this.createPromptoClass(fullName);
                    return super.findClass(fullName);
                }
                catch (Throwable t) {
                    t = this.extractSyntaxError(t);
                    logger.error(() -> "Compilation of " + fullName + " failed. Check: " + TempDirectories.getJavaClassesDir().getAbsolutePath(), t);
                    throw new ClassNotFoundException(fullName, t);
                }
            }
            throw e;
        }
    }

    private void createPromptoClass(String fullName) throws Exception {
        File classDir = this.getClassDir();
        Compiler compiler = new Compiler(classDir);
        compiler.compileClass(this.context.getGlobalsContext(), fullName);
    }

    private Throwable extractSyntaxError(Throwable t) {
        for (Throwable s = t; s != null; s = s.getCause()) {
            if (s instanceof SyntaxError) {
                return s;
            }
            if (s == s.getCause()) break;
        }
        return t;
    }
}

