/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import prompto.compiler.NamedType;

public class ResultInfo {
    Type type;
    boolean isReturn = false;
    boolean isBreak = false;
    boolean isThrow = false;
    boolean isStatic = false;
    boolean isSuper = false;
    Boolean isPrimitive = null;
    Boolean isInterface = null;
    Boolean isPromptoCategory = null;
    Boolean isNativeCategory = null;
    Boolean isPromptoAttribute = null;

    public ResultInfo(Type type, Flag ... flags) {
        this.type = type;
        for (Flag flag : flags) {
            this.setFlag(flag);
        }
    }

    public ResultInfo withFlag(Flag flag) {
        this.setFlag(flag);
        return this;
    }

    private void setFlag(Flag flag) {
        switch (flag) {
            case RETURN: {
                this.isReturn = true;
                break;
            }
            case BREAK: {
                this.isBreak = true;
                break;
            }
            case THROW: {
                this.isThrow = true;
                break;
            }
            case STATIC: {
                this.isStatic = true;
                break;
            }
            case SUPER: {
                this.isSuper = true;
            }
        }
    }

    public String toString() {
        return this.type.toString();
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPrimitive() {
        if (this.isPrimitive == null) {
            this.isPrimitive = this.type instanceof Class ? Boolean.valueOf(((Class)this.type).isPrimitive()) : Boolean.valueOf(false);
        }
        return this.isPrimitive;
    }

    public boolean isInterface() {
        if (this.isInterface == null) {
            if (this.isPrimitive()) {
                this.isInterface = false;
            } else if (this.type instanceof Class) {
                this.isInterface = ((Class)this.type).isInterface();
            } else if (this.type instanceof NamedType) {
                this.isInterface = this.type.getTypeName().startsWith("\u03c0.") && this.type.getTypeName().indexOf(36) < 0;
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.isInterface;
    }

    public boolean isConcrete() {
        return !this.isInterface();
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    public boolean isReturn() {
        return this.isReturn;
    }

    public boolean isBreak() {
        return this.isBreak;
    }

    public boolean isThrow() {
        return this.isThrow;
    }

    public boolean isPromptoCategory() {
        if (this.isPromptoCategory == null) {
            if (this.isPrimitive()) {
                this.isPromptoCategory = false;
            } else if (this.type instanceof Class) {
                this.isPromptoCategory = false;
            } else if (this.type instanceof NamedType) {
                this.isPromptoCategory = this.type.getTypeName().startsWith("\u03c0.\u03c7.");
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.isPromptoCategory;
    }

    public boolean isNativeCategory() {
        if (this.isNativeCategory == null) {
            if (this.isPrimitive()) {
                this.isNativeCategory = false;
            } else if (this.type instanceof Class) {
                this.isNativeCategory = !((Class)this.type).isInterface();
            } else if (this.type instanceof NamedType) {
                this.isNativeCategory = !this.type.getTypeName().startsWith("\u03c0.\u03c7.");
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.isNativeCategory;
    }

    public boolean isCategory() {
        return this.isPromptoCategory() || this.isNativeCategory();
    }

    public boolean isPromptoAttribute() {
        if (this.isPromptoAttribute == null) {
            if (this.isPrimitive()) {
                this.isPromptoAttribute = false;
            } else if (this.type instanceof Class) {
                this.isPromptoAttribute = false;
            } else if (this.type instanceof NamedType) {
                this.isPromptoAttribute = this.type.getTypeName().startsWith("\u03c0.\u03b1.");
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.isPromptoAttribute;
    }

    public static enum Flag {
        RETURN,
        BREAK,
        THROW,
        STATIC,
        SUPER;

    }
}

