/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import prompto.compiler.ByteWriter;
import prompto.compiler.ClassConstant;
import prompto.compiler.ConstantsPool;
import prompto.compiler.IVerifierEntry;

public abstract class StackEntry
implements IVerifierEntry {
    IVerifierEntry.VerifierType type;

    protected StackEntry(IVerifierEntry.VerifierType type) {
        this.type = type;
    }

    @Override
    public IVerifierEntry.VerifierType getType() {
        return this.type;
    }

    static class TopEntry
    extends PrimitiveEntry {
        ClassConstant className;

        public TopEntry(IVerifierEntry.VerifierType type, ClassConstant className) {
            super(type);
            this.className = className;
        }

        public ClassConstant getClassName() {
            return this.className;
        }

        @Override
        public String toString() {
            return this.className == null ? super.toString() : this.className.toString();
        }
    }

    static class PrimitiveEntry
    extends StackEntry {
        public PrimitiveEntry(IVerifierEntry.VerifierType type) {
            super(type);
        }

        public String toString() {
            return this.type.name();
        }

        @Override
        public int length() {
            return 1;
        }

        @Override
        public void writeTo(ByteWriter writer) {
            this.type.writeTo(writer);
        }
    }

    static class ObjectEntry
    extends StackEntry {
        ClassConstant className;

        public ObjectEntry(IVerifierEntry.VerifierType type, ClassConstant className) {
            super(type);
            this.className = className;
        }

        public String toString() {
            return this.className.toString();
        }

        public void setClassName(ClassConstant className) {
            this.className = className;
        }

        @Override
        public void register(ConstantsPool pool) {
            super.register(pool);
            this.className.register(pool);
        }

        @Override
        public int length() {
            return 3;
        }

        @Override
        public void writeTo(ByteWriter writer) {
            this.type.writeTo(writer);
            writer.writeU2(this.className.getIndexInConstantPool());
        }
    }
}

