/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import prompto.compiler.ByteWriter;
import prompto.compiler.ConstantsPool;
import prompto.compiler.DumpLevel;
import prompto.compiler.StackState;

public abstract class StackLabel {
    int realOffset = -1;
    int deltaOffset = -1;

    public void setRealOffset(int offset) {
        if (DumpLevel.current() == DumpLevel.STACK) {
            System.err.println("Setting state real offset " + this.toString() + " to " + offset);
        }
        this.realOffset = offset;
    }

    public int getRealOffset() {
        return this.realOffset;
    }

    public void setDeltaOffset(int offset) {
        if (DumpLevel.current() == DumpLevel.STACK) {
            System.err.println("Setting state delta offset " + this.toString() + " to " + offset);
        }
        this.deltaOffset = offset;
    }

    public int getDeltaOffset() {
        return this.deltaOffset;
    }

    public abstract int length();

    public abstract void writeTo(ByteWriter var1);

    public void register(ConstantsPool pool) {
    }

    public static class FULL
    extends StackLabel {
        StackState state;

        public FULL(StackState state) {
            if (DumpLevel.current() == DumpLevel.STACK) {
                System.err.println("New state " + this.toString());
            }
            this.state = state;
        }

        @Override
        public void register(ConstantsPool pool) {
            if (DumpLevel.current() == DumpLevel.STACK) {
                System.err.println("Registering state " + this.toString());
            }
            this.state.register(pool);
        }

        @Override
        public int length() {
            if (DumpLevel.current() == DumpLevel.STACK) {
                System.err.println("Computing length of state " + this.toString());
            }
            return 5 + this.state.localsLength() + 2 + this.state.stackLength();
        }

        @Override
        public void writeTo(ByteWriter writer) {
            if (DumpLevel.current() == DumpLevel.STACK) {
                System.err.println("Writing state " + this.toString());
            }
            if (this.deltaOffset == -1) {
                throw new UnsupportedOperationException();
            }
            writer.writeU1(255);
            writer.writeU2(this.deltaOffset);
            writer.writeU2(this.state.getLocals().size());
            this.state.getLocals().forEach(l -> l.writeTo(writer));
            writer.writeU2(this.state.getEntries().size());
            this.state.getEntries().forEach(e -> e.writeTo(writer));
        }
    }

    public static class SAME
    extends StackLabel {
        @Override
        public int length() {
            if (this.deltaOffset == -1) {
                throw new UnsupportedOperationException();
            }
            return this.deltaOffset < 64 ? 1 : 3;
        }

        @Override
        public void writeTo(ByteWriter writer) {
            if (this.deltaOffset == -1) {
                throw new UnsupportedOperationException();
            }
            if (this.deltaOffset < 64) {
                this.writeSAME(writer);
            } else {
                this.writeSAME_Extended(writer);
            }
        }

        private void writeSAME_Extended(ByteWriter writer) {
            writer.writeU1(251);
            writer.writeU2(this.deltaOffset);
        }

        private void writeSAME(ByteWriter writer) {
            writer.writeU1(this.deltaOffset);
        }
    }
}

