/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import prompto.compiler.ByteWriter;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerException;
import prompto.compiler.ConstantsPool;
import prompto.compiler.IVerifierEntry;

public abstract class StackLocal
implements IVerifierEntry {
    IVerifierEntry.VerifierType type;
    String name;
    short index = (short)-1;

    public StackLocal(IVerifierEntry.VerifierType type, String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    public IVerifierEntry.VerifierType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setIndex(short index) {
        this.index = index;
    }

    public short getIndex() {
        if (this.index == -1) {
            throw new CompilerException("Local not registered: " + this.name);
        }
        return this.index;
    }

    static class PrimitiveLocal
    extends StackLocal {
        public PrimitiveLocal(IVerifierEntry.VerifierType type, String name) {
            super(type, name);
        }

        public String toString() {
            return this.type.name();
        }

        @Override
        public int length() {
            return 1;
        }

        @Override
        public void writeTo(ByteWriter writer) {
            this.type.writeTo(writer);
        }
    }

    static class TopLocal
    extends ObjectLocal {
        public TopLocal(String name, ClassConstant className) {
            super(IVerifierEntry.VerifierType.ITEM_Top, name, className);
        }

        @Override
        public int length() {
            return 1;
        }

        @Override
        public void writeTo(ByteWriter writer) {
            this.type.writeTo(writer);
        }
    }

    static class ThisLocal
    extends ObjectLocal {
        public ThisLocal(ClassConstant className) {
            super(IVerifierEntry.VerifierType.ITEM_UninitializedThis, "this", className);
        }

        @Override
        public int length() {
            return 1;
        }

        @Override
        public void writeTo(ByteWriter writer) {
            this.type.writeTo(writer);
        }
    }

    public static class ObjectLocal
    extends StackLocal {
        ClassConstant className;
        ClassConstant downcastTo;

        public ObjectLocal(IVerifierEntry.VerifierType type, String name, ClassConstant className) {
            super(type, name);
            this.className = className;
        }

        public ClassConstant getClassName() {
            return this.className;
        }

        public void markForAutodowncast(ClassConstant downcastTo) {
            this.downcastTo = downcastTo;
        }

        public void unmarkForAutodowncast() {
            this.downcastTo = null;
        }

        public ClassConstant getDowncastTo() {
            return this.downcastTo;
        }

        public String toString() {
            return this.className.toString();
        }

        @Override
        public void register(ConstantsPool pool) {
            super.register(pool);
            this.className.register(pool);
        }

        @Override
        public int length() {
            return 3;
        }

        @Override
        public void writeTo(ByteWriter writer) {
            this.type.writeTo(writer);
            writer.writeU2(this.className.getIndexInConstantPool());
        }
    }
}

