/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import prompto.compiler.ByteWriter;
import prompto.compiler.ConstantsPool;
import prompto.compiler.DumpLevel;
import prompto.compiler.IAttribute;
import prompto.compiler.StackEntry;
import prompto.compiler.StackLabel;
import prompto.compiler.StackLocal;
import prompto.compiler.StackState;
import prompto.compiler.Utf8Constant;

public class StackMapTableAttribute
implements IAttribute {
    Utf8Constant attributeName = new Utf8Constant("StackMapTable");
    StackState state = new StackState();
    List<StackLabel> labels = new ArrayList<StackLabel>();
    short maxStackSize = 0;
    short maxLocalsCount = 0;

    public StackState getState() {
        return this.state;
    }

    public short getMaxStack() {
        return this.maxStackSize;
    }

    public short getMaxLocals() {
        return (short)(1 + this.maxLocalsCount);
    }

    public void addLabel(StackLabel label) {
        this.labels.add(label);
    }

    public void push(StackEntry ... entries) {
        for (StackEntry e : entries) {
            this.push(e);
        }
    }

    public StackEntry push(StackEntry item) {
        StackEntry result = this.state.pushEntry(item);
        if (this.state.getCurrentSize() > this.maxStackSize) {
            if (DumpLevel.current() == DumpLevel.STACK) {
                System.err.print("maxStackSize " + this.maxStackSize);
            }
            this.maxStackSize = this.state.getCurrentSize();
            if (DumpLevel.current() == DumpLevel.STACK) {
                System.err.println(" -> " + this.maxStackSize);
            }
        }
        return result;
    }

    public StackEntry[] pop(short popped) {
        StackEntry[] result = new StackEntry[popped];
        while (true) {
            short s = popped;
            popped = (short)(popped - 1);
            if (s <= 0) break;
            result[popped] = this.popEntry();
        }
        return result;
    }

    public StackEntry popEntry() {
        return this.state.popEntry();
    }

    private int labelsLength() {
        return this.labels.stream().mapToInt(l -> l.length()).sum();
    }

    @Override
    public void register(ConstantsPool pool) {
        this.attributeName.register(pool);
        this.state.register(pool);
        this.labels.forEach(l -> l.register(pool));
    }

    public StackLocal pushLocal(StackLocal local) {
        if (local.getIndex() >= this.maxLocalsCount) {
            this.maxLocalsCount = (short)(1 + local.getIndex());
        }
        this.state.pushLocal(local);
        return local;
    }

    public StackLocal popLocal(StackLocal local) {
        if (local != this.state.peekLocal()) {
            throw new UnsupportedOperationException();
        }
        return this.state.popLocal();
    }

    @Override
    public int lengthWithoutHeader() {
        this.cleanupAndOptimize();
        return 2 + this.labelsLength();
    }

    private void cleanupAndOptimize() {
        this.removeRedundantLabels();
    }

    private void removeRedundantLabels() {
        int lastRealOffset = -1;
        ArrayList<StackLabel> labels = new ArrayList<StackLabel>();
        for (StackLabel label : this.labels) {
            if (lastRealOffset != label.getRealOffset()) {
                labels.add(label);
            }
            lastRealOffset = label.getRealOffset();
        }
        this.labels = labels;
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU2(this.attributeName.getIndexInConstantPool());
        writer.writeU4(this.lengthWithoutHeader());
        writer.writeU2((short)this.labels.size());
        int lastRealOffset = 0;
        for (StackLabel label : this.labels) {
            int deltaOffset = label.getRealOffset() - (lastRealOffset == 0 ? lastRealOffset : lastRealOffset + 1);
            label.setDeltaOffset(deltaOffset);
            lastRealOffset = label.getRealOffset();
        }
        this.labels.forEach(l -> l.writeTo(writer));
    }

    public byte[] getData() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteWriter writer = new ByteWriter(output);
        this.writeTo(writer);
        return output.toByteArray();
    }
}

