/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.util.Stack;
import prompto.compiler.ConstantsPool;
import prompto.compiler.DumpLevel;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.StackEntry;
import prompto.compiler.StackLocal;

public class StackState {
    private Stack<StackEntry> entries = new Stack();
    private Stack<StackLocal> locals = new Stack();
    private short currentSize = 0;

    public String toString() {
        return "locals: " + this.locals.toString() + ", stack: " + this.entries.toString();
    }

    public Stack<StackEntry> getEntries() {
        return this.entries;
    }

    public Stack<StackLocal> getLocals() {
        return this.locals;
    }

    public short getCurrentSize() {
        return this.currentSize;
    }

    public void capture(StackState state, boolean entries, boolean locals) {
        if (entries) {
            this.entries = new Stack();
            this.entries.addAll(state.entries);
            this.currentSize = state.currentSize;
        }
        if (locals) {
            this.locals = new Stack();
            this.locals.addAll(state.locals);
        }
    }

    public int stackLength() {
        return this.length(this.entries);
    }

    public int localsLength() {
        return this.length(this.locals);
    }

    private int length(Stack<? extends IVerifierEntry> stack) {
        return stack.stream().mapToInt(e -> e.length()).sum();
    }

    public StackEntry pushEntry(StackEntry entry) {
        if (DumpLevel.current() == DumpLevel.STACK) {
            System.err.print("currentStackSize " + this.currentSize);
        }
        StackEntry result = this.entries.push(entry);
        this.currentSize = (short)(this.currentSize + entry.getType().size());
        if (DumpLevel.current() == DumpLevel.STACK) {
            System.err.println(" -> " + this.currentSize);
        }
        return result;
    }

    public StackEntry popEntry() {
        if (DumpLevel.current() == DumpLevel.STACK) {
            System.err.print("currentStackSize " + this.currentSize);
        }
        StackEntry result = this.entries.pop();
        this.currentSize = (short)(this.currentSize - result.getType().size());
        if (DumpLevel.current() == DumpLevel.STACK) {
            System.err.println(" -> " + this.currentSize);
        }
        return result;
    }

    public StackLocal pushLocal(StackLocal item) {
        return this.locals.push(item);
    }

    public StackLocal peekLocal() {
        return this.locals.peek();
    }

    public StackLocal popLocal() {
        return this.locals.pop();
    }

    public void register(ConstantsPool pool) {
        this.entries.forEach(e -> e.register(pool));
        this.locals.forEach(l -> l.register(pool));
    }
}

