/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import java.lang.reflect.Type;
import prompto.compiler.ByteWriter;
import prompto.compiler.ClassConstant;
import prompto.compiler.ConstantsPool;
import prompto.compiler.IValueConstant;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.StackEntry;
import prompto.compiler.Utf8Constant;

public class StringConstant
implements IValueConstant {
    Utf8Constant value;
    int index;

    public StringConstant(String value) {
        this.value = new Utf8Constant(value);
    }

    @Override
    public int getTag() {
        return 8;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public StackEntry toStackEntry() {
        return IVerifierEntry.VerifierType.ITEM_Object.newStackEntry(new ClassConstant((Type)((Object)String.class)));
    }

    public boolean equals(Object obj) {
        return obj instanceof StringConstant && this.value.equals(((StringConstant)obj).value);
    }

    @Override
    public int getIndexInConstantPool() {
        return this.index;
    }

    @Override
    public void register(ConstantsPool pool) {
        this.index = pool.registerConstant(this);
        this.value.register(pool);
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU1(8);
        writer.writeU2(this.value.getIndexInConstantPool());
    }
}

