/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler;

import prompto.compiler.ByteWriter;
import prompto.compiler.ConstantsPool;
import prompto.compiler.IInternalConstant;

public class Utf8Constant
implements IInternalConstant {
    String value;
    int index;

    public Utf8Constant(String value) {
        this.value = value;
    }

    @Override
    public int getTag() {
        return 1;
    }

    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Utf8Constant && this.value.equals(((Utf8Constant)obj).value);
    }

    @Override
    public int getIndexInConstantPool() {
        if (this.index == -1) {
            throw new UnsupportedOperationException();
        }
        return this.index;
    }

    @Override
    public void register(ConstantsPool pool) {
        this.index = pool.registerConstant(this);
    }

    @Override
    public void writeTo(ByteWriter writer) {
        writer.writeU1(1);
        byte[] utf8 = Utf8Constant.toModifiedUtf8(this.value);
        writer.writeU2(utf8.length);
        writer.writeBytes(utf8);
    }

    static byte[] toModifiedUtf8(String s) {
        char[] cc = s.toCharArray();
        byte[] bb = new byte[cc.length * 6];
        int len = 0;
        for (char c : cc) {
            if (c >= '\u0001' && c <= '\u007f') {
                bb[len++] = (byte)(c & 0x7F);
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                bb[len++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bb[len++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c >= '\u0800' && c <= '\uffff') {
                bb[len++] = (byte)(0xE0 | c >> 12 & 0xF);
                bb[len++] = (byte)(0x80 | c >> 6 & 0x3F);
                bb[len++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bb[len++] = -19;
            bb[len++] = (byte)(0xA0 | c - '\u0001' >> 16 & 0xF);
            bb[len++] = (byte)(0x80 | c >> 10 & 0x3F);
            bb[len++] = -19;
            bb[len++] = (byte)(0x80 | c >> 6 & 0x3F);
            bb[len++] = (byte)(0x80 | c & 0x3F);
        }
        byte[] res = new byte[len];
        System.arraycopy(bb, 0, res, 0, len);
        return res;
    }
}

