/*
 * Decompiled with CFR 0.152.
 */
package prompto.compiler.comparator;

import java.lang.reflect.Type;
import java.util.Comparator;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NamedType;
import prompto.compiler.Opcode;
import prompto.compiler.comparator.ComparatorCompiler;
import prompto.expression.IExpression;
import prompto.runtime.Context;
import prompto.type.IType;

public abstract class ComparatorCompilerBase
implements ComparatorCompiler {
    @Override
    public Type compile(Context context, ClassFile parentClass, IType itemType, IExpression key, boolean descending) {
        int innerClassIndex = 1 + parentClass.getInnerClasses().size();
        String innerClassName = parentClass.getThisClass().getType().getTypeName() + '$' + innerClassIndex;
        NamedType innerClassType = new NamedType(innerClassName);
        ClassFile classFile = new ClassFile(innerClassType);
        classFile.setSuperClass(new ClassConstant((Type)((Object)Object.class)));
        classFile.addInterface(new ClassConstant((Type)((Object)Comparator.class)));
        CompilerUtils.compileEmptyConstructor(classFile);
        this.compileBridge(context, classFile, itemType.getJavaType(context), descending);
        this.compileMethods(context, classFile, itemType, key);
        parentClass.addInnerClass(classFile);
        return innerClassType;
    }

    private void compileCompareMethod(Context context, ClassFile classFile, IType paramIType, IExpression key) {
        Type paramType = paramIType.getJavaType(context);
        Descriptor.Method proto = new Descriptor.Method(paramType, paramType, Integer.TYPE);
        MethodInfo method = classFile.newMethod("compare", proto);
        method.registerLocal("$this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        this.registerLocals(context, method, paramType, key);
        this.compileMethodBody(context, method, paramIType, key);
    }

    protected void registerLocals(Context context, MethodInfo method, Type paramType, IExpression key) {
        method.registerLocal("o1", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(paramType));
        method.registerLocal("o2", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(paramType));
    }

    protected abstract void compileMethodBody(Context var1, MethodInfo var2, IType var3, IExpression var4);

    protected void compileMethods(Context context, ClassFile classFile, IType paramIType, IExpression key) {
        this.compileCompareMethod(context, classFile, paramIType, key);
    }

    private void compileBridge(Context context, ClassFile classFile, Type paramType, boolean descending) {
        Descriptor.Method proto = new Descriptor.Method(new Type[]{Object.class, Object.class, Integer.TYPE});
        MethodInfo method = classFile.newMethod("compare", proto);
        method.addModifier(4160);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        method.registerLocal("o1", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)Object.class)));
        method.registerLocal("o2", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)Object.class)));
        method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
        if (descending) {
            method.addInstruction(Opcode.ALOAD_2, new ClassConstant((Type)((Object)Object.class)));
            method.addInstruction(Opcode.CHECKCAST, new ClassConstant(paramType));
            method.addInstruction(Opcode.ALOAD_1, new ClassConstant((Type)((Object)Object.class)));
            method.addInstruction(Opcode.CHECKCAST, new ClassConstant(paramType));
        } else {
            method.addInstruction(Opcode.ALOAD_1, new ClassConstant((Type)((Object)Object.class)));
            method.addInstruction(Opcode.CHECKCAST, new ClassConstant(paramType));
            method.addInstruction(Opcode.ALOAD_2, new ClassConstant((Type)((Object)Object.class)));
            method.addInstruction(Opcode.CHECKCAST, new ClassConstant(paramType));
        }
        proto = new Descriptor.Method(paramType, paramType, Integer.TYPE);
        MethodConstant c = new MethodConstant(classFile.getThisClass(), "compare", proto);
        method.addInstruction(Opcode.INVOKEVIRTUAL, c);
        method.addInstruction(Opcode.IRETURN, new IOperand[0]);
    }
}

